/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import io.jboot.components.gateway.GatewayHttpProxy;
import io.jboot.components.gateway.GatewayInterceptor;
import io.jboot.components.gateway.GatewaySentinelProcesser;
import io.jboot.components.gateway.GatewayUtil;
import io.jboot.components.gateway.JbootGatewayConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GatewayInvocation {
    private JbootGatewayConfig config;
    private GatewayInterceptor[] inters;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private GatewayHttpProxy proxy;
    private int index = 0;

    public GatewayInvocation(JbootGatewayConfig config, HttpServletRequest request, HttpServletResponse response) {
        this.config = config;
        this.request = request;
        this.response = response;
        this.proxy = new GatewayHttpProxy(config);
        this.inters = config.buildInterceptors();
    }

    public void invoke() {
        if (this.inters == null || this.inters.length == 0) {
            this.doInvoke();
            return;
        }
        if (this.index < this.inters.length) {
            this.inters[this.index++].intercept(this);
        } else if (this.index++ >= this.inters.length) {
            this.doInvoke();
        }
    }

    protected void doInvoke() {
        Runnable runnable = () -> this.proxy.sendRequest(GatewayUtil.buildProxyUrl(this.config, this.request), this.request, this.response);
        if (this.config.isSentinelEnable()) {
            new GatewaySentinelProcesser().process(runnable, this.config, this.request, this.response);
        } else {
            runnable.run();
        }
    }

    public JbootGatewayConfig getConfig() {
        return this.config;
    }

    public void setConfig(JbootGatewayConfig config) {
        this.config = config;
    }

    public GatewayInterceptor[] getInters() {
        return this.inters;
    }

    public void setInters(GatewayInterceptor[] inters) {
        this.inters = inters;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public GatewayHttpProxy getProxy() {
        return this.proxy;
    }

    public boolean hasException() {
        return this.proxy.getException() != null;
    }
}

