/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.jfinal.kit.JsonKit;
import com.jfinal.kit.LogKit;
import io.jboot.components.gateway.GatewayUtil;
import io.jboot.components.gateway.JbootGatewayConfig;
import io.jboot.utils.StrUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GatewaySentinelProcesser {
    protected static final String contentType = "application/json; charset=utf-8";

    public void process(Runnable runnable, JbootGatewayConfig config, HttpServletRequest req, HttpServletResponse resp) {
        Entry entry = null;
        String resourceName = GatewayUtil.buildResource(req);
        try {
            entry = SphU.entry((String)resourceName, (int)3, (EntryType)EntryType.IN);
            runnable.run();
        }
        catch (BlockException ex) {
            GatewaySentinelProcesser.processBlocked(config, req, resp);
        }
        catch (Exception ex) {
            Tracer.traceEntry((Throwable)ex, (Entry)entry);
            throw ex;
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
        }
    }

    private static void processBlocked(JbootGatewayConfig config, HttpServletRequest req, HttpServletResponse resp) {
        StringBuffer url = req.getRequestURL();
        if ("GET".equals(req.getMethod()) && StrUtil.isNotBlank(req.getQueryString())) {
            url.append("?").append(req.getQueryString());
        }
        try {
            if (StringUtil.isNotBlank((String)config.getSentinelBlockPage())) {
                String redirectUrl = config.getSentinelBlockPage() + "?http_referer=" + url.toString();
                resp.sendRedirect(redirectUrl);
            } else if (config.getSentinelBlockJsonMap() != null && !config.getSentinelBlockJsonMap().isEmpty()) {
                GatewaySentinelProcesser.writeDefaultBlockedJson(resp, config.getSentinelBlockJsonMap());
            } else {
                GatewaySentinelProcesser.writeDefaultBlockedPage(resp);
            }
        }
        catch (IOException ex) {
            LogKit.error((String)ex.toString(), (Throwable)ex);
        }
    }

    private static void writeDefaultBlockedJson(HttpServletResponse resp, Map map) throws IOException {
        resp.setStatus(200);
        resp.setContentType(contentType);
        PrintWriter out = resp.getWriter();
        out.print(JsonKit.toJson((Object)map));
    }

    private static void writeDefaultBlockedPage(HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        PrintWriter out = resp.getWriter();
        out.print("Blocked by Sentinel (flow limiting) in Jboot");
    }
}

