/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import com.alibaba.csp.sentinel.util.StringUtil;
import io.jboot.components.gateway.JbootGatewayConfig;
import io.jboot.utils.StrUtil;
import javax.servlet.http.HttpServletRequest;

public class GatewayUtil {
    private static final String PATH_SPLIT = "/";

    public static String buildProxyUrl(JbootGatewayConfig config, HttpServletRequest request) {
        StringBuilder url = new StringBuilder(config.getRandomUri());
        if (StrUtil.isNotBlank(request.getRequestURI())) {
            url.append(request.getRequestURI());
        }
        if (StrUtil.isNotBlank(request.getQueryString())) {
            url.append("?").append(request.getQueryString());
        }
        return url.toString();
    }

    public static String buildResource(HttpServletRequest request) {
        String pathInfo = GatewayUtil.getResourcePath(request);
        if (!pathInfo.startsWith(PATH_SPLIT)) {
            pathInfo = PATH_SPLIT + pathInfo;
        }
        if (PATH_SPLIT.equals(pathInfo)) {
            return pathInfo;
        }
        int lastSlashIndex = pathInfo.lastIndexOf(PATH_SPLIT);
        pathInfo = lastSlashIndex >= 0 ? pathInfo.substring(0, lastSlashIndex) + PATH_SPLIT + StringUtil.trim((String)pathInfo.substring(lastSlashIndex + 1)) : PATH_SPLIT + StringUtil.trim((String)pathInfo);
        return pathInfo;
    }

    private static String getResourcePath(HttpServletRequest request) {
        String pathInfo = GatewayUtil.normalizeAbsolutePath(request.getPathInfo(), false);
        String servletPath = GatewayUtil.normalizeAbsolutePath(request.getServletPath(), pathInfo.length() != 0);
        return servletPath + pathInfo;
    }

    private static String normalizeAbsolutePath(String path, boolean removeTrailingSlash) throws IllegalStateException {
        return GatewayUtil.normalizePath(path, true, false, removeTrailingSlash);
    }

    private static String normalizePath(String path, boolean forceAbsolute, boolean forceRelative, boolean removeTrailingSlash) throws IllegalStateException {
        char[] pathChars = StringUtil.trimToEmpty((String)path).toCharArray();
        int length = pathChars.length;
        boolean startsWithSlash = false;
        boolean endsWithSlash = false;
        if (length > 0) {
            char firstChar = pathChars[0];
            char lastChar = pathChars[length - 1];
            startsWithSlash = firstChar == PATH_SPLIT.charAt(0) || firstChar == '\\';
            endsWithSlash = lastChar == PATH_SPLIT.charAt(0) || lastChar == '\\';
        }
        StringBuilder buf = new StringBuilder(length);
        boolean isAbsolutePath = forceAbsolute || !forceRelative && startsWithSlash;
        int index = startsWithSlash ? 0 : -1;
        int level = 0;
        if (isAbsolutePath) {
            buf.append(PATH_SPLIT);
        }
        while (index < length && (index = GatewayUtil.indexOfSlash(pathChars, index + 1, false)) != length) {
            int nextSlashIndex = GatewayUtil.indexOfSlash(pathChars, index, true);
            String element = new String(pathChars, index, nextSlashIndex - index);
            index = nextSlashIndex;
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                if (level == 0) {
                    if (isAbsolutePath) {
                        throw new IllegalStateException(path);
                    }
                    buf.append("..").append(PATH_SPLIT);
                    continue;
                }
                buf.setLength(pathChars[--level]);
                continue;
            }
            pathChars[level++] = (char)buf.length();
            buf.append(element).append(PATH_SPLIT);
        }
        if (buf.length() > 0 && (!endsWithSlash || removeTrailingSlash)) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private static int indexOfSlash(char[] chars, int beginIndex, boolean slash) {
        int i;
        for (i = beginIndex; i < chars.length; ++i) {
            char ch = chars[i];
            if (slash ? ch == PATH_SPLIT.charAt(0) || ch == '\\' : ch != PATH_SPLIT.charAt(0) && ch != '\\') break;
        }
        return i;
    }
}

