/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import io.jboot.components.gateway.GatewayInterceptor;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.http.HttpServletRequest;

public class JbootGatewayConfig
implements Serializable {
    public static final String DEFAULT_PROXY_CONTENT_TYPE = "text/html;charset=utf-8";
    private String name;
    private String[] uri;
    private boolean enable = false;
    private boolean sentinelEnable = false;
    private String sentinelBlockPage;
    private Map<String, String> sentinelBlockJsonMap;
    private int proxyReadTimeout = 10000;
    private int proxyConnectTimeout = 5000;
    private int proxyRetries = 2;
    private String proxyContentType = "text/html;charset=utf-8";
    private String[] pathEquals;
    private String[] pathContains;
    private String[] pathStartsWith;
    private String[] pathEndsWith;
    private String[] hostEquals;
    private String[] hostContains;
    private String[] hostStartsWith;
    private String[] hostEndsWith;
    private Map<String, String> queryEquals;
    private String[] queryContains;
    private String[] interceptors;
    private GatewayInterceptor[] inters;
    private Boolean configOk = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getUri() {
        return this.uri;
    }

    public void setUri(String[] uri) {
        this.uri = uri;
    }

    public String getRandomUri() {
        if (this.uri == null || this.uri.length == 0) {
            return null;
        }
        if (this.uri.length == 1) {
            return this.uri[0];
        }
        return this.uri[ThreadLocalRandom.current().nextInt(this.uri.length)];
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isSentinelEnable() {
        return this.sentinelEnable;
    }

    public void setSentinelEnable(boolean sentinelEnable) {
        this.sentinelEnable = sentinelEnable;
    }

    public String getSentinelBlockPage() {
        return this.sentinelBlockPage;
    }

    public void setSentinelBlockPage(String sentinelBlockPage) {
        this.sentinelBlockPage = sentinelBlockPage;
    }

    public Map<String, String> getSentinelBlockJsonMap() {
        return this.sentinelBlockJsonMap;
    }

    public void setSentinelBlockJsonMap(Map<String, String> sentinelBlockJsonMap) {
        this.sentinelBlockJsonMap = sentinelBlockJsonMap;
    }

    public int getProxyReadTimeout() {
        return this.proxyReadTimeout;
    }

    public void setProxyReadTimeout(int proxyReadTimeout) {
        this.proxyReadTimeout = proxyReadTimeout;
    }

    public int getProxyConnectTimeout() {
        return this.proxyConnectTimeout;
    }

    public void setProxyConnectTimeout(int proxyConnectTimeout) {
        this.proxyConnectTimeout = proxyConnectTimeout;
    }

    public int getProxyRetries() {
        return this.proxyRetries;
    }

    public void setProxyRetries(int proxyRetries) {
        this.proxyRetries = proxyRetries;
    }

    public String getProxyContentType() {
        return this.proxyContentType;
    }

    public void setProxyContentType(String proxyContentType) {
        this.proxyContentType = proxyContentType;
    }

    public String[] getPathEquals() {
        return this.pathEquals;
    }

    public void setPathEquals(String[] pathEquals) {
        this.pathEquals = pathEquals;
    }

    public String[] getPathContains() {
        return this.pathContains;
    }

    public void setPathContains(String[] pathContains) {
        this.pathContains = pathContains;
    }

    public String[] getPathStartsWith() {
        return this.pathStartsWith;
    }

    public void setPathStartsWith(String[] pathStartsWith) {
        this.pathStartsWith = pathStartsWith;
    }

    public String[] getPathEndsWith() {
        return this.pathEndsWith;
    }

    public void setPathEndsWith(String[] pathEndsWith) {
        this.pathEndsWith = pathEndsWith;
    }

    public String[] getHostEquals() {
        return this.hostEquals;
    }

    public void setHostEquals(String[] hostEquals) {
        this.hostEquals = hostEquals;
    }

    public String[] getHostContains() {
        return this.hostContains;
    }

    public void setHostContains(String[] hostContains) {
        this.hostContains = hostContains;
    }

    public String[] getHostStartsWith() {
        return this.hostStartsWith;
    }

    public void setHostStartsWith(String[] hostStartsWith) {
        this.hostStartsWith = hostStartsWith;
    }

    public String[] getHostEndsWith() {
        return this.hostEndsWith;
    }

    public void setHostEndsWith(String[] hostEndsWith) {
        this.hostEndsWith = hostEndsWith;
    }

    public Map<String, String> getQueryEquals() {
        return this.queryEquals;
    }

    public void setQueryEquals(Map<String, String> queryEquals) {
        this.queryEquals = queryEquals;
    }

    public String[] getQueryContains() {
        return this.queryContains;
    }

    public void setQueryContains(String[] queryContains) {
        this.queryContains = queryContains;
    }

    public String[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(String[] interceptors) {
        this.interceptors = interceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GatewayInterceptor[] buildInterceptors() {
        if (this.interceptors == null || this.interceptors.length == 0) {
            return null;
        }
        if (this.inters == null) {
            JbootGatewayConfig jbootGatewayConfig = this;
            synchronized (jbootGatewayConfig) {
                if (this.inters == null) {
                    this.inters = new GatewayInterceptor[this.interceptors.length];
                    for (int i = 0; i < this.interceptors.length; ++i) {
                        GatewayInterceptor interceptor = (GatewayInterceptor)ClassUtil.newInstance(this.interceptors[i]);
                        if (interceptor == null) {
                            throw new NullPointerException("can not new instance by class:" + this.interceptors[i]);
                        }
                        this.inters[i] = interceptor;
                    }
                }
            }
        }
        return this.inters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfigOk() {
        if (this.configOk != null) {
            return this.configOk;
        }
        JbootGatewayConfig jbootGatewayConfig = this;
        synchronized (jbootGatewayConfig) {
            if (this.configOk == null) {
                this.configOk = this.uri != null && this.uri.length > 0;
                if (this.configOk.booleanValue()) {
                    this.ensureUriConfigCorrect();
                }
            }
        }
        return this.configOk;
    }

    private void ensureUriConfigCorrect() {
        for (String u : this.uri) {
            if (u.toLowerCase().startsWith("http://") || u.toLowerCase().startsWith("https://")) continue;
            throw new JbootIllegalConfigException("gateway uri must start with http:// or https://");
        }
    }

    public boolean matches(HttpServletRequest request) {
        Map<String, String> queryMap;
        if (request == null) {
            return false;
        }
        String path = request.getServletPath();
        if (this.pathEquals != null) {
            for (String p : this.pathEquals) {
                if (!path.equals(p)) continue;
                return true;
            }
        }
        if (this.pathContains != null) {
            for (String p : this.pathContains) {
                if (!path.contains(p)) continue;
                return true;
            }
        }
        if (this.pathStartsWith != null) {
            for (String p : this.pathStartsWith) {
                if (!path.startsWith(p)) continue;
                return true;
            }
        }
        if (this.pathEndsWith != null) {
            for (String p : this.pathEndsWith) {
                if (!path.endsWith(p)) continue;
                return true;
            }
        }
        String host = request.getServerName();
        if (this.hostEquals != null) {
            for (String h : this.hostEquals) {
                if (!host.equals(h)) continue;
                return true;
            }
        }
        if (this.hostContains != null) {
            for (String h : this.hostContains) {
                if (!host.contains(h)) continue;
                return true;
            }
        }
        if (this.hostStartsWith != null) {
            for (String h : this.hostStartsWith) {
                if (!host.startsWith(h)) continue;
                return true;
            }
        }
        if (this.hostEndsWith != null) {
            for (String h : this.hostEndsWith) {
                if (!host.endsWith(h)) continue;
                return true;
            }
        }
        if (!(this.queryContains == null && this.queryEquals == null || (queryMap = JbootGatewayConfig.queryStringToMap(request.getQueryString())) == null || queryMap.isEmpty())) {
            if (this.queryContains != null) {
                for (String q : this.queryContains) {
                    if (!queryMap.containsKey(q)) continue;
                    return true;
                }
            }
            if (this.queryEquals != null) {
                for (Map.Entry<String, String> e : this.queryEquals.entrySet()) {
                    String queryValue = queryMap.get(e.getKey());
                    if (!Objects.equals(queryValue, e.getValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Map<String, String> queryStringToMap(String queryString) {
        if (StrUtil.isBlank((String)queryString)) {
            return null;
        }
        String[] params = queryString.split("&");
        HashMap<String, String> resMap = new HashMap<String, String>();
        for (int i = 0; i < params.length; ++i) {
            String[] param = params[i].split("=");
            if (param.length < 2) continue;
            String key = param[0];
            String value = param[1];
            for (int j = 2; j < param.length; ++j) {
                value = value + "=" + param[j];
            }
            resMap.put(key, value);
        }
        return resMap;
    }
}

