/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import io.jboot.app.config.JbootConfigUtil;
import io.jboot.components.gateway.JbootGatewayConfig;
import io.jboot.utils.StrUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public class JbootGatewayManager {
    private static JbootGatewayManager me = new JbootGatewayManager();
    private Map<String, JbootGatewayConfig> configMap;

    public static JbootGatewayManager me() {
        return me;
    }

    public void init() {
        Map<String, JbootGatewayConfig> configMap = JbootConfigUtil.getConfigModels(JbootGatewayConfig.class, "jboot.gateway");
        if (configMap != null && !configMap.isEmpty()) {
            for (Map.Entry<String, JbootGatewayConfig> e : configMap.entrySet()) {
                JbootGatewayConfig config = e.getValue();
                if (!config.isConfigOk() || !config.isEnable()) continue;
                if (StrUtil.isBlank((String)config.getName())) {
                    config.setName(e.getKey());
                }
                this.registerConfig(config);
            }
        }
    }

    public synchronized void registerConfig(JbootGatewayConfig config) {
        if (this.configMap == null) {
            this.configMap = new ConcurrentHashMap<String, JbootGatewayConfig>();
        }
        this.configMap.put(config.getName(), config);
    }

    public JbootGatewayConfig removeConfig(String name) {
        return this.configMap == null ? null : this.configMap.remove(name);
    }

    public JbootGatewayConfig getConfig(String name) {
        return this.configMap == null ? null : this.configMap.get(name);
    }

    public Map<String, JbootGatewayConfig> getConfigMap() {
        return this.configMap;
    }

    public JbootGatewayConfig matchingConfig(HttpServletRequest req) {
        if (this.configMap != null && !this.configMap.isEmpty()) {
            for (JbootGatewayConfig config : this.configMap.values()) {
                if (!config.matches(req)) continue;
                return config;
            }
        }
        return null;
    }
}

