/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.http;

import io.jboot.Jboot;
import io.jboot.components.http.JbootHttp;
import io.jboot.components.http.JbootHttpConfig;
import io.jboot.components.http.jboot.JbootHttpImpl;
import io.jboot.components.http.okhttp.OKHttpImpl;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.utils.ClassUtil;

public class JbootHttpManager {
    private static JbootHttpManager manager;
    private JbootHttp jbootHttp;

    public static JbootHttpManager me() {
        if (manager == null) {
            manager = ClassUtil.singleton(JbootHttpManager.class);
        }
        return manager;
    }

    public JbootHttp getJbootHttp() {
        if (this.jbootHttp == null) {
            this.jbootHttp = this.buildJbootHttp();
        }
        return this.jbootHttp;
    }

    private JbootHttp buildJbootHttp() {
        JbootHttpConfig config = Jboot.config(JbootHttpConfig.class);
        switch (config.getType()) {
            case "default": {
                return new JbootHttpImpl();
            }
            case "okhttp": {
                return new OKHttpImpl();
            }
            case "httpclient": {
                throw new RuntimeException("not finished!!!!");
            }
        }
        return JbootSpiLoader.load(JbootHttp.class, config.getType());
    }
}

