/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.http.okhttp;

import com.jfinal.log.Log;
import io.jboot.components.http.JbootHttp;
import io.jboot.components.http.JbootHttpRequest;
import io.jboot.components.http.JbootHttpResponse;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OKHttpImpl
implements JbootHttp {
    private static final Log LOG = Log.getLog(OKHttpImpl.class);
    private static X509TrustManager trustAnyTrustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };
    private static HostnameVerifier hnv = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    @Override
    public JbootHttpResponse handle(JbootHttpRequest request) {
        JbootHttpResponse response = request.getDownloadFile() == null ? new JbootHttpResponse() : new JbootHttpResponse(request.getDownloadFile());
        this.doProcess(request, response);
        return response;
    }

    private void doProcess(JbootHttpRequest request, JbootHttpResponse response) {
        try {
            if (request.isPostRequest()) {
                this.doProcessPostRequest(request, response);
            } else {
                request.initGetUrl();
                this.doProcessGetRequest(request, response);
            }
        }
        catch (Throwable ex) {
            LOG.error(ex.toString(), ex);
            response.setError(ex);
        }
    }

    private void doProcessGetRequest(JbootHttpRequest request, JbootHttpResponse response) throws Exception {
        Request okHttpRequest = new Request.Builder().url(request.getRequestUrl()).build();
        this.doProcessRequest(request, response, okHttpRequest);
    }

    private void doProcessPostRequest(JbootHttpRequest request, JbootHttpResponse response) throws Exception {
        RequestBody requestBody = null;
        if (request.isMultipartFormData()) {
            MultipartBody.Builder builder = new MultipartBody.Builder();
            for (Map.Entry<String, Object> entry : request.getParams().entrySet()) {
                if (entry.getValue() instanceof File) {
                    File file = (File)entry.getValue();
                    builder.addFormDataPart(entry.getKey(), file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
                    continue;
                }
                builder.addFormDataPart(entry.getKey(), entry.getValue() == null ? "" : entry.getValue().toString());
            }
            requestBody = builder.build();
        } else {
            MediaType mediaType = MediaType.parse((String)request.getContentType());
            requestBody = RequestBody.create((MediaType)mediaType, (String)request.getPostContent());
        }
        Request okHttpRequest = new Request.Builder().url(request.getRequestUrl()).post(requestBody).build();
        this.doProcessRequest(request, response, okHttpRequest);
    }

    private void doProcessRequest(JbootHttpRequest request, JbootHttpResponse response, Request okHttpRequest) throws Exception {
        OkHttpClient client = this.getClient(request);
        Call call = client.newCall(okHttpRequest);
        Response okHttpResponse = call.execute();
        response.setResponseCode(okHttpResponse.code());
        response.setContentType(okHttpResponse.body().contentType().type());
        response.pipe(okHttpResponse.body().byteStream());
        response.finish();
    }

    private OkHttpClient getClient(JbootHttpRequest request) throws Exception {
        if (request.getRequestUrl().toLowerCase().startsWith("https")) {
            return this.getHttpsClient(request);
        }
        return new OkHttpClient();
    }

    public OkHttpClient getHttpsClient(JbootHttpRequest request) throws Exception {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (request.getCertPath() != null && request.getCertPass() != null) {
            KeyStore clientStore = KeyStore.getInstance("PKCS12");
            clientStore.load(new FileInputStream(request.getCertPath()), request.getCertPass().toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(clientStore, request.getCertPass().toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(clientStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("TLSv1");
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            X509TrustManager x509TrustManager = trustAnyTrustManager;
            if (trustManagers != null && trustManagers.length > 0 && trustManagers[0] instanceof X509TrustManager) {
                x509TrustManager = (X509TrustManager)trustManagers[0];
            }
            builder.sslSocketFactory(sslContext.getSocketFactory(), x509TrustManager);
        } else {
            builder.hostnameVerifier(hnv);
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            if (sslContext != null) {
                TrustManager[] trustManagers = new TrustManager[]{trustAnyTrustManager};
                sslContext.init(null, trustManagers, new SecureRandom());
                builder.sslSocketFactory(sslContext.getSocketFactory(), trustAnyTrustManager);
            }
        }
        return builder.build();
    }
}

