/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.limiter;

import com.google.common.util.concurrent.RateLimiter;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.components.limiter.LimiterManager;
import io.jboot.components.limiter.annotation.EnableLimit;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.fixedinterceptor.FixedInterceptor;
import java.util.concurrent.Semaphore;
import javax.servlet.http.HttpServletRequest;

public class LimiterInterceptor
implements FixedInterceptor,
Interceptor {
    @Override
    public void intercept(Invocation inv) {
        String packageOrTarget = this.getPackageOrTarget(inv);
        LimiterManager.TypeAndRate typeAndRate = LimiterManager.me().matchConfig(packageOrTarget);
        if (typeAndRate != null) {
            this.doInterceptByTypeAndRate(typeAndRate, packageOrTarget, inv);
            return;
        }
        EnableLimit enableLimit = inv.getMethod().getAnnotation(EnableLimit.class);
        if (enableLimit != null) {
            String resource = StrUtil.obtainDefaultIfBlank(enableLimit.resource(), packageOrTarget);
            this.doInterceptByLimitInfo(enableLimit, resource, inv);
            return;
        }
        inv.invoke();
    }

    private void doInterceptByTypeAndRate(LimiterManager.TypeAndRate typeAndRate, String resource, Invocation inv) {
        switch (typeAndRate.getType()) {
            case "cc": {
                this.doInterceptForConcurrency(typeAndRate.getRate(), resource, null, inv);
                break;
            }
            case "tb": {
                this.doInterceptForTokenBucket(typeAndRate.getRate(), resource, null, inv);
            }
        }
    }

    private void doInterceptByLimitInfo(EnableLimit enableLimit, String resource, Invocation inv) {
        String type;
        switch (type = AnnotationUtil.get(enableLimit.type())) {
            case "cc": {
                this.doInterceptForConcurrency(enableLimit.rate(), resource, enableLimit.fallback(), inv);
                break;
            }
            case "tb": {
                this.doInterceptForTokenBucket(enableLimit.rate(), resource, enableLimit.fallback(), inv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInterceptForConcurrency(int rate, String resource, String fallback, Invocation inv) {
        Semaphore semaphore = LimiterManager.me().getOrCreateSemaphore(resource, rate);
        boolean acquire = false;
        try {
            acquire = semaphore.tryAcquire();
            if (acquire) {
                inv.invoke();
            } else {
                this.doExecFallback(resource, fallback, inv);
            }
        }
        finally {
            if (acquire) {
                semaphore.release();
            }
        }
    }

    private void doInterceptForTokenBucket(int rate, String resource, String fallback, Invocation inv) {
        RateLimiter limiter = LimiterManager.me().getOrCreateRateLimiter(resource, rate);
        if (limiter.tryAcquire()) {
            inv.invoke();
        } else {
            this.doExecFallback(resource, fallback, inv);
        }
    }

    private void doExecFallback(String resource, String fallback, Invocation inv) {
        LimiterManager.me().processFallback(resource, fallback, inv);
    }

    private String getPackageOrTarget(Invocation inv) {
        return inv.isActionInvocation() ? this.buildUrl(inv) : ClassUtil.buildMethodString(inv.getMethod());
    }

    private String buildUrl(Invocation inv) {
        HttpServletRequest request = inv.getController().getRequest();
        String uri = request.getRequestURI();
        String query = request.getQueryString();
        return StrUtil.isBlank((String)query) ? uri : uri + "?" + query;
    }
}

