/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.mq;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.components.mq.Jbootmq;
import io.jboot.components.mq.JbootmqConfig;
import io.jboot.components.mq.JbootmqMessageListener;
import io.jboot.components.serializer.JbootSerializer;
import io.jboot.components.serializer.JbootSerializerManager;
import io.jboot.exception.JbootException;
import io.jboot.utils.NamedThreadFactory;
import io.jboot.utils.StrUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class JbootmqBase
implements Jbootmq {
    private static final Log LOG = Log.getLog(JbootmqBase.class);
    private List<JbootmqMessageListener> globalListeners = new CopyOnWriteArrayList<JbootmqMessageListener>();
    private Multimap<String, JbootmqMessageListener> channelListeners = ArrayListMultimap.create();
    protected JbootmqConfig config = Jboot.config(JbootmqConfig.class);
    protected Set<String> channels = Sets.newHashSet();
    protected Set<String> syncRecevieMessageChannels = Sets.newHashSet();
    protected JbootSerializer serializer;
    private final ExecutorService threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("jbootmq"));
    protected boolean isStartListen = false;

    public JbootmqBase() {
        String channelString = this.config.getChannel();
        if (StrUtil.isBlank((String)channelString)) {
            return;
        }
        this.channels.addAll(StrUtil.splitToSet(channelString, ","));
        if (StrUtil.isNotBlank(this.config.getSyncRecevieMessageChannel())) {
            this.syncRecevieMessageChannels.addAll(StrUtil.splitToSet(this.config.getSyncRecevieMessageChannel(), ","));
        }
    }

    @Override
    public void addMessageListener(JbootmqMessageListener listener) {
        this.globalListeners.add(listener);
    }

    @Override
    public void addMessageListener(JbootmqMessageListener listener, String forChannel) {
        String[] forChannels;
        for (String channel : forChannels = forChannel.split(",")) {
            if (StrUtil.isBlank((String)channel)) continue;
            this.channelListeners.put((Object)channel.trim(), (Object)listener);
        }
    }

    @Override
    public void removeListener(JbootmqMessageListener listener) {
        this.globalListeners.remove(listener);
        for (String channel : this.channelListeners.keySet()) {
            this.channelListeners.remove((Object)channel, (Object)listener);
        }
    }

    @Override
    public void removeAllListeners() {
        this.globalListeners.clear();
        this.channelListeners.clear();
    }

    @Override
    public Collection<JbootmqMessageListener> getGlobalListeners() {
        return this.globalListeners;
    }

    @Override
    public Collection<JbootmqMessageListener> getListenersByChannel(String channel) {
        return this.channelListeners.get((Object)channel);
    }

    public void notifyListeners(String channel, Object message) {
        boolean globalResult = this.notifyListeners(channel, message, this.globalListeners);
        boolean channelResult = this.notifyListeners(channel, message, this.channelListeners.get((Object)channel));
        if (!globalResult && !channelResult) {
            LOG.error("application has recevied mq message, bug has no listener to process it. channel:" + channel + "  message:" + message);
        }
    }

    protected boolean notifyListeners(String channel, Object message, Collection<JbootmqMessageListener> listeners) {
        if (listeners == null || listeners.size() == 0) {
            return false;
        }
        if (this.syncRecevieMessageChannels.contains(channel)) {
            for (JbootmqMessageListener listener : listeners) {
                try {
                    listener.onMessage(channel, message);
                }
                catch (Throwable ex) {
                    LOG.warn("listener[" + listener.getClass().getName() + "] execute mq message is error. channel:" + channel + "  message:" + message);
                }
            }
        } else {
            for (JbootmqMessageListener listener : listeners) {
                this.threadPool.execute(() -> listener.onMessage(channel, message));
            }
        }
        return true;
    }

    public JbootSerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = StrUtil.isBlank((String)this.config.getSerializer()) ? Jboot.getSerializer() : JbootSerializerManager.me().getSerializer(this.config.getSerializer());
        }
        return this.serializer;
    }

    @Override
    public boolean startListening() {
        if (this.isStartListen) {
            throw new JbootException("jboot mq is started before.");
        }
        if (this.channels == null || this.channels.isEmpty()) {
            throw new JbootException("mq channels is null or empty, please config channels");
        }
        this.onStartListening();
        this.isStartListen = true;
        return true;
    }

    protected abstract void onStartListening();
}

