/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.mq.aliyunmq;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import io.jboot.Jboot;
import io.jboot.components.mq.Jbootmq;
import io.jboot.components.mq.JbootmqBase;
import io.jboot.components.mq.aliyunmq.JbootAliyunmqConfig;
import java.util.Properties;

public class JbootAliyunmqImpl
extends JbootmqBase
implements Jbootmq,
MessageListener {
    private Producer producer;
    private Consumer consumer;

    public JbootAliyunmqImpl() {
        Properties properties = this.createProperties();
        this.producer = ONSFactory.createProducer((Properties)properties);
        this.producer.start();
    }

    @Override
    protected void onStartListening() {
        Properties properties = this.createProperties();
        this.consumer = ONSFactory.createConsumer((Properties)properties);
        for (String c : this.channels) {
            this.consumer.subscribe(c, "*", (MessageListener)this);
        }
        this.consumer.start();
    }

    @Override
    public void enqueue(Object message, String toChannel) {
        throw new RuntimeException("not finished!");
    }

    @Override
    public void publish(Object message, String toChannel) {
        byte[] bytes = this.getSerializer().serialize(message);
        Message onsMessage = new Message(toChannel, "*", bytes);
        this.producer.send(onsMessage);
    }

    public Action consume(Message message, ConsumeContext context) {
        byte[] bytes = message.getBody();
        Object object = this.getSerializer().deserialize(bytes);
        this.notifyListeners(message.getTopic(), object);
        return Action.CommitMessage;
    }

    private Properties createProperties() {
        JbootAliyunmqConfig aliyunmqConfig = Jboot.config(JbootAliyunmqConfig.class);
        Properties properties = new Properties();
        properties.put("AccessKey", aliyunmqConfig.getAccessKey());
        properties.put("SecretKey", aliyunmqConfig.getSecretKey());
        properties.put("ProducerId", aliyunmqConfig.getProducerId());
        properties.put("ONSAddr", aliyunmqConfig.getAddr());
        properties.setProperty("SendMsgTimeoutMillis", aliyunmqConfig.getSendMsgTimeoutMillis());
        return properties;
    }
}

