/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.mq.qpidmq;

import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.components.mq.Jbootmq;
import io.jboot.components.mq.JbootmqBase;
import io.jboot.components.mq.qpidmq.JbootQpidmqConfig;
import io.jboot.exception.JbootException;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.StrUtil;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.qpid.client.AMQAnyDestination;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.jms.Connection;

public class JbootQpidmqImpl
extends JbootmqBase
implements Jbootmq {
    private static final Log LOG = Log.getLog(JbootQpidmqImpl.class);
    private Connection connection = null;
    private boolean serializerEnable = true;

    public JbootQpidmqImpl() {
        JbootQpidmqConfig qpidConfig = Jboot.config(JbootQpidmqConfig.class);
        this.serializerEnable = qpidConfig.isSerializerEnable();
        try {
            String url = this.getConnectionUrl();
            this.connection = new AMQConnection(url);
            this.connection.start();
        }
        catch (Exception e) {
            throw new JbootException("can not connection qpidmq server", e);
        }
    }

    @Override
    protected void onStartListening() {
        try {
            this.startReceiveMsgThread();
        }
        catch (Exception e) {
            throw new JbootException(e.toString(), e);
        }
    }

    @Override
    public void enqueue(Object message, String toChannel) {
        String addr = this.getQueueAddr(toChannel);
        this.sendMsg(addr, message);
    }

    @Override
    public void publish(Object message, String toChannel) {
        String addr = this.getTopicAddr(toChannel);
        this.sendMsg(addr, message);
    }

    public void sendMsg(String addr, Object message) {
        try {
            Session session = this.connection.createSession(false, 1);
            AMQAnyDestination destination = new AMQAnyDestination(addr.toString());
            MessageProducer producer = session.createProducer((Destination)destination);
            producer.setTimeToLive(30000L);
            TextMessage m = null;
            if (!this.serializerEnable) {
                m = session.createTextMessage((String)message);
            } else {
                byte[] data = this.getSerializer().serialize(message);
                m = session.createBytesMessage();
                m.setIntProperty("data-len", data.length);
                ((BytesMessage)m).writeBytes(data);
            }
            producer.send((Message)m);
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
        }
    }

    private String getConnectionUrl() {
        String[] hosts;
        JbootQpidmqConfig qpidConfig = Jboot.config(JbootQpidmqConfig.class);
        StringBuffer url = new StringBuffer();
        url.append("amqp://");
        url.append(qpidConfig.getUsername());
        url.append(":");
        url.append(qpidConfig.getPassword());
        url.append("@");
        url.append("/");
        url.append(qpidConfig.getVirtualHost());
        url.append("?failover='roundrobin'");
        url.append("&brokerlist='");
        String host = qpidConfig.getHost();
        for (String h : hosts = host.split(",")) {
            if (StrUtil.isBlank((String)h)) continue;
            url.append("tcp://" + h + ";");
        }
        url.append("'");
        return url.toString();
    }

    private String getQueueAddr(String channel) {
        StringBuffer addr = new StringBuffer();
        addr.append("ADDR:");
        addr.append(channel);
        addr.append(";{create:always}");
        return addr.toString();
    }

    private String getTopicAddr(String channel) {
        StringBuffer addr = new StringBuffer();
        addr.append("ADDR:amq.topic/");
        addr.append(channel);
        return addr.toString();
    }

    private void startReceiveMsgThread() throws Exception {
        if (ArrayUtil.isNullOrEmpty(this.channels)) {
            return;
        }
        for (String channel : this.channels) {
            Session session = this.connection.createSession(false, 1);
            String queueAddr = this.getQueueAddr(channel);
            AMQAnyDestination queue = new AMQAnyDestination(queueAddr);
            MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
            new Thread(new ReceiveMsgThread(queueConsumer, channel, this.serializerEnable)).start();
            String topicAddr = this.getTopicAddr(channel);
            AMQAnyDestination topic = new AMQAnyDestination(topicAddr);
            MessageConsumer topicConsumer = session.createConsumer((Destination)topic);
            new Thread(new ReceiveMsgThread(topicConsumer, channel, this.serializerEnable)).start();
        }
    }

    private class ReceiveMsgThread
    implements Runnable {
        private MessageConsumer consumer;
        private String channel;
        private boolean serializerEnable;

        public ReceiveMsgThread(MessageConsumer consumer, String channel, boolean serializerEnable) {
            this.consumer = consumer;
            this.channel = channel;
            this.serializerEnable = serializerEnable;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Message message;
                    if ((message = this.consumer.receive()) == null) {
                        continue;
                    }
                    Object object = null;
                    if (!this.serializerEnable) {
                        TextMessage textMessage = (TextMessage)message;
                        object = textMessage.getText();
                    } else {
                        byte[] data;
                        BytesMessage bytesMessage = (BytesMessage)message;
                        int dataLen = bytesMessage.getIntProperty("data-len");
                        if (dataLen != bytesMessage.readBytes(data = new byte[dataLen])) continue;
                        object = JbootQpidmqImpl.this.getSerializer().deserialize(data);
                    }
                    if (object == null) continue;
                    JbootQpidmqImpl.this.notifyListeners(this.channel, object);
                }
            }
            catch (Exception e) {
                LOG.error(e.toString(), (Throwable)e);
                return;
            }
        }
    }
}

