/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc;

import io.jboot.Jboot;
import io.jboot.components.rpc.Jbootrpc;
import io.jboot.components.rpc.JbootrpcConfig;
import io.jboot.components.rpc.JbootrpcReferenceConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JbootrpcBase
implements Jbootrpc {
    protected static final Map<String, Object> objectCache = new ConcurrentHashMap<String, Object>();
    protected static JbootrpcConfig rpcConfig = Jboot.config(JbootrpcConfig.class);
    private boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T serviceObtain(Class<T> interfaceClass, JbootrpcReferenceConfig config) {
        String key = this.buildCacheKey(interfaceClass, config);
        Object object = objectCache.get(key);
        if (object == null) {
            JbootrpcBase jbootrpcBase = this;
            synchronized (jbootrpcBase) {
                if (objectCache.get(key) == null) {
                    this.callStartMethodIfNecessary();
                    object = this.onServiceCreate(interfaceClass, config);
                    if (object != null) {
                        objectCache.put(key, object);
                    }
                }
            }
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callStartMethodIfNecessary() {
        if (!this.started) {
            JbootrpcBase jbootrpcBase = this;
            synchronized (jbootrpcBase) {
                if (!this.started) {
                    this.onStart();
                }
            }
        }
    }

    public abstract <T> T onServiceCreate(Class<T> var1, JbootrpcReferenceConfig var2);

    @Override
    public void onStart() {
        this.setStarted(true);
    }

    @Override
    public void onStop() {
    }

    protected String buildCacheKey(Class interfaceClass, JbootrpcReferenceConfig config) {
        StringBuilder sb = new StringBuilder(interfaceClass.getName());
        return sb.append(":").append(config.getGroup()).append(":").append(config.getVersion()).toString();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }
}

