/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc;

import com.jfinal.aop.Aop;
import io.jboot.Jboot;
import io.jboot.components.event.JbootEventListener;
import io.jboot.components.mq.JbootmqMessageListener;
import io.jboot.components.rpc.Jbootrpc;
import io.jboot.components.rpc.JbootrpcConfig;
import io.jboot.components.rpc.JbootrpcServiceConfig;
import io.jboot.components.rpc.annotation.RPCBean;
import io.jboot.components.rpc.dubbo.JbootDubborpc;
import io.jboot.components.rpc.local.JbootLocalrpc;
import io.jboot.components.rpc.motan.JbootMotanrpc;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.exception.JbootException;
import io.jboot.exception.JbootRpcException;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassScanner;
import java.io.Serializable;
import java.util.List;

public class JbootrpcManager {
    private static JbootrpcManager manager = new JbootrpcManager();
    private Jbootrpc jbootrpc;
    private JbootrpcConfig defaultConfig = Jboot.config(JbootrpcConfig.class);
    private static Class[] default_excludes = new Class[]{JbootEventListener.class, JbootmqMessageListener.class, Serializable.class};

    public static JbootrpcManager me() {
        return manager;
    }

    public Jbootrpc getJbootrpc() {
        if (this.jbootrpc == null) {
            if (!this.defaultConfig.isConfigOk()) {
                throw new JbootRpcException("jboot rpc config is error, please set up jboot.rpc.type config value");
            }
            this.jbootrpc = this.createJbootrpc(this.defaultConfig.getType());
        }
        return this.jbootrpc;
    }

    public void init() {
        if (!this.defaultConfig.isConfigOk()) {
            return;
        }
        Jbootrpc jbootrpc = this.getJbootrpc();
        jbootrpc.onStart();
        if (this.defaultConfig.isAutoExportEnable()) {
            this.exportRPCBean(jbootrpc);
        }
    }

    public void stop() {
        if (this.defaultConfig.isConfigOk()) {
            this.getJbootrpc().onStop();
        }
    }

    public void exportRPCBean(Jbootrpc jbootrpc) {
        List<Class> classes = ClassScanner.scanClassByAnnotation(RPCBean.class, true);
        if (ArrayUtil.isNullOrEmpty(classes)) {
            return;
        }
        for (Class clazz : classes) {
            RPCBean rpcBean = clazz.getAnnotation(RPCBean.class);
            Class<?>[] inters = clazz.getInterfaces();
            if (inters == null || inters.length == 0) {
                throw new JbootException(String.format("class[%s] has no interface, can not use @RPCBean", clazz));
            }
            Class[] excludes = ArrayUtil.concat(default_excludes, new Class[][]{rpcBean.exclude()});
            for (Class<?> inter : inters) {
                boolean isContinue = false;
                for (Class ex : excludes) {
                    if (!ex.isAssignableFrom(inter)) continue;
                    isContinue = true;
                    break;
                }
                if (isContinue) continue;
                jbootrpc.serviceExport(inter, Aop.get((Class)clazz), new JbootrpcServiceConfig(rpcBean));
            }
        }
    }

    public Jbootrpc createJbootrpc(String type) {
        switch (type) {
            case "motan": {
                return new JbootMotanrpc();
            }
            case "local": {
                return new JbootLocalrpc();
            }
            case "dubbo": {
                return new JbootDubborpc();
            }
        }
        return JbootSpiLoader.load(Jbootrpc.class, type);
    }
}

