/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc.dubbo;

import io.jboot.components.rpc.JbootrpcBase;
import io.jboot.components.rpc.JbootrpcReferenceConfig;
import io.jboot.components.rpc.JbootrpcServiceConfig;
import io.jboot.components.rpc.dubbo.DubboUtil;
import io.jboot.utils.StrUtil;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.ServiceConfig;

public class JbootDubborpc
extends JbootrpcBase {
    @Override
    public void onStart() {
        DubboUtil.initDubbo();
        this.setStarted(true);
    }

    @Override
    public void onStop() {
        DubboUtil.stopDubbo();
    }

    @Override
    public <T> T onServiceCreate(Class<T> interfaceClass, JbootrpcReferenceConfig config) {
        String consumer;
        ReferenceConfig reference = DubboUtil.toReferenceConfig(config);
        reference.setInterface(interfaceClass);
        String directUrl = rpcConfig.getUrl(interfaceClass.getName());
        if (StrUtil.isNotBlank(directUrl)) {
            reference.setUrl(directUrl);
        }
        if ((consumer = rpcConfig.getConsumer(interfaceClass.getName())) != null) {
            reference.setConsumer(DubboUtil.getConsumer(consumer));
        }
        if (reference.getGroup() == null) {
            reference.setGroup(rpcConfig.getGroup(interfaceClass.getName()));
        }
        if (reference.getVersion() == null) {
            reference.setVersion(rpcConfig.getVersion(interfaceClass.getName()));
        }
        return (T)reference.get();
    }

    @Override
    public <T> boolean serviceExport(Class<T> interfaceClass, Object object, JbootrpcServiceConfig config) {
        ServiceConfig service = DubboUtil.toServiceConfig(config);
        service.setInterface(interfaceClass);
        service.setRef(object);
        String provider = rpcConfig.getProvider(interfaceClass.getName());
        if (provider != null) {
            service.setProvider(DubboUtil.getProvider(provider));
        }
        if (service.getGroup() == null) {
            service.setGroup(rpcConfig.getGroup(interfaceClass.getName()));
        }
        if (service.getVersion() == null) {
            service.setVersion(rpcConfig.getVersion(interfaceClass.getName()));
        }
        service.export();
        return true;
    }
}

