/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc.motan;

import com.weibo.api.motan.config.RefererConfig;
import com.weibo.api.motan.config.ServiceConfig;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import io.jboot.Jboot;
import io.jboot.components.rpc.JbootrpcBase;
import io.jboot.components.rpc.JbootrpcReferenceConfig;
import io.jboot.components.rpc.JbootrpcServiceConfig;
import io.jboot.components.rpc.motan.MotanUtil;
import io.jboot.components.rpc.motan.MotanrpcConfig;
import io.jboot.utils.StrUtil;

public class JbootMotanrpc
extends JbootrpcBase {
    private MotanrpcConfig defaultConfig = Jboot.config(MotanrpcConfig.class);

    @Override
    public void onStart() {
        MotanUtil.initMotan();
        this.setStarted(true);
    }

    @Override
    public <T> T onServiceCreate(Class<T> interfaceClass, JbootrpcReferenceConfig config) {
        String consumer;
        RefererConfig referer = MotanUtil.toRefererConfig(config);
        referer.setInterface(interfaceClass);
        String directUrl = rpcConfig.getUrl(interfaceClass.getName());
        if (StrUtil.isNotBlank(directUrl)) {
            referer.setDirectUrl(directUrl);
        }
        if ((consumer = rpcConfig.getConsumer(interfaceClass.getName())) != null) {
            referer.setBasicReferer(MotanUtil.getBaseReferer(consumer));
        }
        if (referer.getGroup() == null) {
            referer.setGroup(rpcConfig.getGroup(interfaceClass.getName()));
        }
        if (referer.getVersion() == null) {
            referer.setVersion(rpcConfig.getVersion(interfaceClass.getName()));
        }
        return (T)referer.getRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean serviceExport(Class<T> interfaceClass, Object object, JbootrpcServiceConfig config) {
        JbootMotanrpc jbootMotanrpc = this;
        synchronized (jbootMotanrpc) {
            MotanSwitcherUtil.setSwitcherValue((String)"feature.configserver.heartbeat", (boolean)false);
            ServiceConfig service = MotanUtil.toServiceConfig(config);
            service.setInterface(interfaceClass);
            service.setRef(object);
            service.setShareChannel(Boolean.valueOf(true));
            service.setExport(this.defaultConfig.getExport(interfaceClass.getName()));
            service.setHost(this.defaultConfig.getHost(interfaceClass.getName()));
            String provider = rpcConfig.getProvider(interfaceClass.getName());
            if (provider != null) {
                service.setBasicService(MotanUtil.getBaseService(provider));
            }
            if (service.getGroup() == null) {
                service.setGroup(rpcConfig.getGroup(interfaceClass.getName()));
            }
            if (service.getVersion() == null) {
                service.setVersion(rpcConfig.getVersion(interfaceClass.getName()));
            }
            service.export();
            MotanSwitcherUtil.setSwitcherValue((String)"feature.configserver.heartbeat", (boolean)true);
        }
        return true;
    }
}

