/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc.motan;

import com.weibo.api.motan.config.AbstractConfig;
import com.weibo.api.motan.config.BasicRefererInterfaceConfig;
import com.weibo.api.motan.config.BasicServiceInterfaceConfig;
import com.weibo.api.motan.config.MethodConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RefererConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.config.ServiceConfig;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import io.jboot.app.config.JbootConfigUtil;
import io.jboot.components.rpc.JbootrpcReferenceConfig;
import io.jboot.components.rpc.JbootrpcServiceConfig;
import io.jboot.components.rpc.RPCUtil;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MotanUtil {
    private static Map<String, ProtocolConfig> protocolConfigMap = new ConcurrentHashMap<String, ProtocolConfig>();
    private static Map<String, RegistryConfig> registryConfigMap = new ConcurrentHashMap<String, RegistryConfig>();
    private static Map<String, BasicRefererInterfaceConfig> baseRefererConfigMap = new ConcurrentHashMap<String, BasicRefererInterfaceConfig>();
    private static Map<String, BasicServiceInterfaceConfig> baseServiceConfigMap = new ConcurrentHashMap<String, BasicServiceInterfaceConfig>();

    public static void initMotan() {
        Map<String, ProtocolConfig> protocolConfigs = MotanUtil.configs(ProtocolConfig.class, "jboot.rpc.motan.protocol");
        if (protocolConfigs != null && !protocolConfigs.isEmpty()) {
            protocolConfigMap.putAll(protocolConfigs);
        } else {
            protocolConfigMap.put("default", MotanFrameworkUtil.getDefaultProtocolConfig());
        }
        Map<String, RegistryConfig> registryConfigs = MotanUtil.configs(RegistryConfig.class, "jboot.rpc.motan.registry");
        if (registryConfigs != null && !registryConfigs.isEmpty()) {
            registryConfigMap.putAll(registryConfigs);
        } else {
            registryConfigMap.put("default", MotanFrameworkUtil.getDefaultRegistryConfig());
        }
        Map<String, MethodConfig> methodConfigs = MotanUtil.configs(MethodConfig.class, "jboot.rpc.motan.method");
        Map<String, BasicServiceInterfaceConfig> serviceConfigs = MotanUtil.configs(BasicServiceInterfaceConfig.class, "jboot.rpc.motan.service");
        RPCUtil.setChildConfig(serviceConfigs, methodConfigs, "jboot.rpc.motan.service", "method");
        RPCUtil.setChildConfig(serviceConfigs, protocolConfigs, "jboot.rpc.motan.service", "protocol");
        RPCUtil.setChildConfig(serviceConfigs, registryConfigs, "jboot.rpc.motan.service", "registry");
        if (serviceConfigs != null && !serviceConfigs.isEmpty()) {
            baseServiceConfigMap.putAll(serviceConfigs);
        }
        Map<String, BasicRefererInterfaceConfig> refererConfigs = MotanUtil.configs(BasicRefererInterfaceConfig.class, "jboot.rpc.motan.referer");
        RPCUtil.setChildConfig(refererConfigs, methodConfigs, "jboot.rpc.motan.referer", "method");
        RPCUtil.setChildConfig(refererConfigs, protocolConfigs, "jboot.rpc.motan.referer", "protocol");
        RPCUtil.setChildConfig(refererConfigs, registryConfigs, "jboot.rpc.motan.referer", "registry");
        if (refererConfigs != null && !refererConfigs.isEmpty()) {
            baseRefererConfigMap.putAll(refererConfigs);
        }
    }

    public static RefererConfig toRefererConfig(JbootrpcReferenceConfig rc) {
        ProtocolConfig registryConfig;
        RefererConfig refererConfig = new RefererConfig();
        RPCUtil.copyFields(rc, refererConfig);
        if (StrUtil.isNotBlank(rc.getProtocol())) {
            ArrayList<ProtocolConfig> protocolConfigs = new ArrayList<ProtocolConfig>();
            Set<String> protocolNames = StrUtil.splitToSetByComma(rc.getRegistry());
            for (String protocalName : protocolNames) {
                registryConfig = protocolConfigMap.get(protocalName);
                if (registryConfig == null) continue;
                protocolConfigs.add(registryConfig);
            }
            if (!protocolConfigs.isEmpty()) {
                refererConfig.setProtocols(protocolConfigs);
            }
        } else {
            refererConfig.setProtocols(MotanUtil.toList(protocolConfigMap));
        }
        if (StrUtil.isNotBlank(rc.getRegistry())) {
            ArrayList<ProtocolConfig> registryConfigs = new ArrayList<ProtocolConfig>();
            Set<String> registryNames = StrUtil.splitToSetByComma(rc.getRegistry());
            for (String registryName : registryNames) {
                registryConfig = registryConfigMap.get(registryName);
                if (registryConfig == null) continue;
                registryConfigs.add(registryConfig);
            }
            if (!registryConfigs.isEmpty()) {
                refererConfig.setRegistries(registryConfigs);
            }
        } else {
            refererConfig.setRegistries(MotanUtil.toList(registryConfigMap));
        }
        return refererConfig;
    }

    public static ServiceConfig toServiceConfig(JbootrpcServiceConfig sc) {
        ProtocolConfig registryConfig;
        ServiceConfig serviceConfig = new ServiceConfig();
        RPCUtil.copyFields(sc, serviceConfig);
        if (StrUtil.isNotBlank(sc.getProtocol())) {
            ArrayList<ProtocolConfig> protocolConfigs = new ArrayList<ProtocolConfig>();
            Set<String> protocolNames = StrUtil.splitToSetByComma(sc.getRegistry());
            for (String protocalName : protocolNames) {
                registryConfig = protocolConfigMap.get(protocalName);
                if (registryConfig == null) continue;
                protocolConfigs.add(registryConfig);
            }
            if (!protocolConfigs.isEmpty()) {
                serviceConfig.setProtocols(protocolConfigs);
            }
        } else {
            serviceConfig.setProtocols(MotanUtil.toList(protocolConfigMap));
        }
        if (StrUtil.isNotBlank(sc.getRegistry())) {
            ArrayList<ProtocolConfig> registryConfigs = new ArrayList<ProtocolConfig>();
            Set<String> registryNames = StrUtil.splitToSetByComma(sc.getRegistry());
            for (String registryName : registryNames) {
                registryConfig = registryConfigMap.get(registryName);
                if (registryConfig == null) continue;
                registryConfigs.add(registryConfig);
            }
            if (!registryConfigs.isEmpty()) {
                serviceConfig.setRegistries(registryConfigs);
            }
        } else {
            serviceConfig.setRegistries(MotanUtil.toList(registryConfigMap));
        }
        return serviceConfig;
    }

    public static BasicRefererInterfaceConfig getBaseReferer(String name) {
        return baseRefererConfigMap.get(name);
    }

    public static BasicServiceInterfaceConfig getBaseService(String name) {
        return baseServiceConfigMap.get(name);
    }

    private static <T> Map<String, T> configs(Class<T> clazz, String prefix) {
        return JbootConfigUtil.getConfigModels(clazz, prefix);
    }

    private static <T> List<T> toList(Map<String, T> map) {
        ArrayList<AbstractConfig> list = new ArrayList<AbstractConfig>(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            AbstractConfig config = (AbstractConfig)entry.getValue();
            config.setId(entry.getKey());
            list.add(config);
        }
        return list;
    }
}

