/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.schedule;

import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.support.redis.JbootRedis;

public class JbootDistributedRunnable
implements Runnable {
    private static final Log LOG = Log.getLog(JbootDistributedRunnable.class);
    private JbootRedis redis;
    private int expire = 50000;
    private String key;
    private Runnable runnable;

    public JbootDistributedRunnable() {
        this.redis = Jboot.getRedis();
        this.key = "jbootRunnable:" + this.getClass().getName();
        if (this.redis == null) {
            LOG.warn("redis is null, can not use @EnableDistributedRunnable in your Class[" + this.getClass().getName() + "], or config redis info in jboot.properties");
        }
    }

    public JbootDistributedRunnable(Runnable runnable) {
        this.runnable = runnable;
        this.key = "jbootRunnable:" + runnable.getClass().getName();
        this.redis = Jboot.getRedis();
        if (this.redis == null) {
            LOG.warn("redis is null, can not use @EnableDistributedRunnable in your Class[" + runnable.getClass().getName() + "], or config redis info in jboot.properties");
        }
    }

    public JbootDistributedRunnable(Runnable runnable, int expire) {
        this.expire = (expire - 1) * 1000;
        this.runnable = runnable;
        this.key = "jbootRunnable:" + runnable.getClass().getName();
        this.redis = Jboot.getRedis();
        if (this.redis == null) {
            LOG.warn("redis is null, can not use @EnableDistributedRunnable in your Class[" + runnable.getClass().getName() + "], or config redis info in jboot.properties");
        }
    }

    @Override
    public void run() {
        if (this.redis == null) {
            return;
        }
        Long result = null;
        for (int i = 0; i < 5; ++i) {
            Long setTimeMillis = System.currentTimeMillis();
            result = this.redis.setnx(this.key, setTimeMillis);
            if (result == null) {
                this.quietSleep();
                continue;
            }
            if (result == 0L) {
                long ttl;
                Long saveTimeMillis = (Long)this.redis.get(this.key);
                if (saveTimeMillis == null) {
                    this.reset();
                }
                if ((ttl = System.currentTimeMillis() - saveTimeMillis) > (long)this.expire) {
                    this.reset();
                }
                this.quietSleep();
                continue;
            }
            if (result == 1L) break;
        }
        if (result == null || result == 0L) {
            return;
        }
        try {
            if (this.runnable != null) {
                this.runnable.run();
            } else {
                boolean runSuccess = this.execute();
                if (!runSuccess) {
                    this.reset();
                }
            }
        }
        catch (Throwable ex) {
            LOG.error(ex.toString(), ex);
            this.reset();
        }
    }

    private void reset() {
        this.redis.del((Object)this.key);
    }

    public void quietSleep() {
        int millis = 2000;
        if (this.expire <= 2000) {
            millis = 100;
        } else if (this.expire <= 5000) {
            millis = 500;
        } else if (this.expire <= 300000) {
            millis = 1000;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean execute() {
        return true;
    }
}

