/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import io.jboot.components.serializer.JbootSerializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class KryoSerializer
implements JbootSerializer {
    private KryoFactory kryoFactory = () -> new Kryo();
    private KryoPool kryoPool = new KryoPool.Builder(this.kryoFactory).softReferences().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        Output output = null;
        Kryo kryo = this.kryoPool.borrow();
        try {
            output = new Output((OutputStream)new ByteArrayOutputStream());
            kryo.writeClassAndObject(output, obj);
            byte[] byArray = output.toBytes();
            return byArray;
        }
        finally {
            if (output != null) {
                output.close();
            }
            this.kryoPool.release(kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteBufferInput input = null;
        Kryo kryo = this.kryoPool.borrow();
        try {
            input = new ByteBufferInput(bytes);
            Object object = kryo.readClassAndObject((Input)input);
            return object;
        }
        finally {
            if (input != null) {
                input.close();
            }
            this.kryoPool.release(kryo);
        }
    }
}

