/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.core;

import com.jfinal.aop.Aop;
import com.jfinal.aop.AopFactory;
import com.jfinal.aop.AopManager;
import com.jfinal.aop.Interceptor;
import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.core.ActionHandler;
import com.jfinal.core.Controller;
import com.jfinal.core.ControllerFactory;
import com.jfinal.handler.Handler;
import com.jfinal.json.JsonManager;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.PropKit;
import com.jfinal.log.ILogFactory;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.render.IRenderFactory;
import com.jfinal.template.Engine;
import io.jboot.Jboot;
import io.jboot.aop.JbootAopFactory;
import io.jboot.aop.JbootAopInterceptor;
import io.jboot.aop.jfinal.JfinalHandlers;
import io.jboot.aop.jfinal.JfinalPlugins;
import io.jboot.app.config.support.apollo.ApolloServerConfig;
import io.jboot.components.gateway.JbootGatewayHandler;
import io.jboot.components.gateway.JbootGatewayManager;
import io.jboot.components.limiter.LimiterManager;
import io.jboot.components.rpc.JbootrpcManager;
import io.jboot.components.schedule.JbootScheduleManager;
import io.jboot.core.listener.JbootAppListenerManager;
import io.jboot.core.log.Slf4jLogFactory;
import io.jboot.db.ArpManager;
import io.jboot.support.seata.JbootSeataManager;
import io.jboot.support.sentinel.SentinelManager;
import io.jboot.support.shiro.JbootShiroManager;
import io.jboot.support.swagger.JbootSwaggerConfig;
import io.jboot.support.swagger.JbootSwaggerController;
import io.jboot.support.swagger.JbootSwaggerManager;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.JbootJson;
import io.jboot.web.controller.JbootControllerManager;
import io.jboot.web.controller.annotation.RequestMapping;
import io.jboot.web.directive.annotation.JFinalDirective;
import io.jboot.web.directive.annotation.JFinalSharedMethod;
import io.jboot.web.directive.annotation.JFinalSharedObject;
import io.jboot.web.directive.annotation.JFinalSharedStaticMethod;
import io.jboot.web.fixedinterceptor.FixedInterceptors;
import io.jboot.web.handler.JbootActionHandler;
import io.jboot.web.handler.JbootFilterHandler;
import io.jboot.web.handler.JbootHandler;
import io.jboot.web.render.JbootRenderFactory;
import java.io.File;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class JbootCoreConfig
extends JFinalConfig {
    private List<Routes.Route> routeList = new ArrayList<Routes.Route>();

    public JbootCoreConfig() {
        this.initSystemProperties();
        AopManager.me().setInjectDependency(true);
        AopManager.me().setAopFactory((AopFactory)JbootAopFactory.me());
        Aop.inject((Object)((Object)this));
        JbootAppListenerManager.me().onInit();
    }

    private void initSystemProperties() {
        ApolloServerConfig apolloConfig;
        Properties properties;
        File spf = new File(PathKit.getRootClassPath(), "jboot-system.properties");
        if (spf.exists() && spf.isFile() && (properties = PropKit.use((File)spf).getProperties()) != null && !properties.isEmpty()) {
            for (Object key : properties.keySet()) {
                String newValue;
                String newKey;
                String systemValue;
                if (!StrUtil.isNotBlank(key) || StrUtil.isNotBlank(systemValue = System.getProperty(newKey = key.toString().trim())) || !StrUtil.isNotBlank(newValue = properties.getProperty(newKey))) continue;
                System.setProperty(newKey, newValue.trim());
            }
        }
        if ((apolloConfig = Jboot.config(ApolloServerConfig.class)).isEnable() && apolloConfig.isConfigOk()) {
            System.setProperty("app.id", apolloConfig.getAppId());
            System.setProperty("apollo.meta", apolloConfig.getMeta());
        }
    }

    public void configConstant(Constants constants) {
        constants.setRenderFactory((IRenderFactory)JbootRenderFactory.me());
        constants.setDevMode(Jboot.isDevMode());
        constants.setLogFactory((ILogFactory)new Slf4jLogFactory());
        constants.setMaxPostSize(0x7D000000);
        constants.setReportAfterInvocation(false);
        constants.setControllerFactory((ControllerFactory)JbootControllerManager.me());
        constants.setJsonFactory(JbootJson::new);
        constants.setInjectDependency(true);
        JbootAppListenerManager.me().onConstantConfig(constants);
    }

    public void configRoute(Routes routes) {
        JbootSwaggerConfig swaggerConfig;
        routes.setMappingSuperClass(true);
        List<Class<Controller>> controllerClassList = ClassScanner.scanSubClass(Controller.class);
        if (ArrayUtil.isNotEmpty(controllerClassList)) {
            for (Class<Controller> clazz : controllerClassList) {
                String value;
                RequestMapping mapping = clazz.getAnnotation(RequestMapping.class);
                if (mapping == null || (value = AnnotationUtil.get(mapping.value())) == null) continue;
                String viewPath = AnnotationUtil.get(mapping.viewPath());
                if (StrUtil.isNotBlank(viewPath)) {
                    routes.add(value, clazz, viewPath);
                    continue;
                }
                routes.add(value, clazz);
            }
        }
        if ((swaggerConfig = Jboot.config(JbootSwaggerConfig.class)).isConfigOk()) {
            routes.add(swaggerConfig.getPath(), JbootSwaggerController.class, swaggerConfig.getPath());
        }
        JbootAppListenerManager.me().onRouteConfig(routes);
        for (Routes.Route route : routes.getRouteItemList()) {
            JbootControllerManager.me().setMapping(route.getControllerKey(), route.getControllerClass());
        }
        this.routeList.addAll(routes.getRouteItemList());
    }

    public void configEngine(Engine engine) {
        if (this.runInFatjar()) {
            engine.setToClassPathSourceFactory();
            engine.setBaseTemplatePath("webapp");
        }
        List<Class> directiveClasses = ClassScanner.scanClass();
        for (Class clazz : directiveClasses) {
            JFinalSharedObject sharedObject;
            JFinalSharedStaticMethod sharedStaticMethod;
            JFinalSharedMethod sharedMethod;
            JFinalDirective directive = clazz.getAnnotation(JFinalDirective.class);
            if (directive != null) {
                engine.addDirective(AnnotationUtil.get(directive.value()), clazz);
            }
            if ((sharedMethod = clazz.getAnnotation(JFinalSharedMethod.class)) != null) {
                engine.addSharedMethod(ClassUtil.newInstance(clazz));
            }
            if ((sharedStaticMethod = clazz.getAnnotation(JFinalSharedStaticMethod.class)) != null) {
                engine.addSharedStaticMethod(clazz);
            }
            if ((sharedObject = clazz.getAnnotation(JFinalSharedObject.class)) == null) continue;
            engine.addSharedObject(AnnotationUtil.get(sharedObject.value()), ClassUtil.newInstance(clazz));
        }
        JbootAppListenerManager.me().onEngineConfig(engine);
    }

    private boolean runInFatjar() {
        return Thread.currentThread().getContextClassLoader().getResource("") == null;
    }

    public void configPlugin(Plugins plugins) {
        List<ActiveRecordPlugin> arps = ArpManager.me().getActiveRecordPlugins();
        for (ActiveRecordPlugin arp : arps) {
            plugins.add((IPlugin)arp);
        }
        JbootAppListenerManager.me().onPluginConfig(new JfinalPlugins(plugins));
    }

    public void configInterceptor(Interceptors interceptors) {
        interceptors.addGlobalServiceInterceptor((Interceptor)new JbootAopInterceptor());
        JbootAppListenerManager.me().onInterceptorConfig(interceptors);
        JbootAppListenerManager.me().onFixedInterceptorConfig(FixedInterceptors.me());
    }

    public void configHandler(Handlers handlers) {
        JbootAppListenerManager.me().onHandlerConfig(new JfinalHandlers(handlers));
        handlers.add((Handler)new JbootGatewayHandler());
        handlers.add((Handler)new JbootFilterHandler());
        handlers.add((Handler)new JbootHandler());
        if (handlers.getActionHandler() == null) {
            handlers.setActionHandler((ActionHandler)new JbootActionHandler());
        }
    }

    public void onStart() {
        JbootAppListenerManager.me().onStartBefore();
        JsonManager.me().setDefaultDatePattern("yyyy-MM-dd HH:mm:ss");
        JbootrpcManager.me().init();
        JbootShiroManager.me().init(this.routeList);
        JbootScheduleManager.me().init();
        JbootSwaggerManager.me().init();
        LimiterManager.me().init();
        JbootSeataManager.me().init();
        SentinelManager.me().init();
        JbootGatewayManager.me().init();
        JbootAppListenerManager.me().onStart();
        JbootAppListenerManager.me().onStartFinish();
    }

    public void onStop() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        if (drivers != null) {
            while (drivers.hasMoreElements()) {
                try {
                    Driver driver = drivers.nextElement();
                    DriverManager.deregisterDriver(driver);
                }
                catch (Exception e) {
                    LogKit.error((String)e.toString(), (Throwable)e);
                }
            }
        }
        JbootAppListenerManager.me().onStop();
        JbootScheduleManager.me().stop();
        JbootSeataManager.me().stop();
        JbootrpcManager.me().stop();
    }
}

