/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.core.listener;

import com.jfinal.config.Constants;
import com.jfinal.config.Interceptors;
import com.jfinal.config.Routes;
import com.jfinal.log.Log;
import com.jfinal.template.Engine;
import io.jboot.aop.jfinal.JfinalHandlers;
import io.jboot.aop.jfinal.JfinalPlugins;
import io.jboot.core.listener.JbootAppListener;
import io.jboot.core.listener.JbootAppListenerBase;
import io.jboot.core.weight.WeightUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassUtil;
import io.jboot.web.fixedinterceptor.FixedInterceptors;
import java.util.ArrayList;
import java.util.List;

public class JbootAppListenerManager
implements JbootAppListener {
    private static Log log = Log.getLog(JbootAppListenerManager.class);
    private static JbootAppListenerManager me = new JbootAppListenerManager();
    List<JbootAppListener> listeners = new ArrayList<JbootAppListener>();

    public static JbootAppListenerManager me() {
        return me;
    }

    private JbootAppListenerManager() {
        List<Class<JbootAppListener>> allListeners = ClassScanner.scanSubClass(JbootAppListener.class, true);
        if (allListeners == null || allListeners.size() == 0) {
            return;
        }
        for (Class<JbootAppListener> clazz : allListeners) {
            JbootAppListener listener;
            if (JbootAppListenerManager.class == clazz || JbootAppListenerBase.class == clazz || (listener = ClassUtil.newInstance(clazz)) == null) continue;
            this.listeners.add(listener);
        }
        WeightUtil.sort(this.listeners);
    }

    @Override
    public void onInit() {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onInit();
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onConstantConfig(Constants constants) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onConstantConfig(constants);
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onRouteConfig(Routes routes) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onRouteConfig(routes);
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onEngineConfig(Engine engine) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onEngineConfig(engine);
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onPluginConfig(JfinalPlugins plugins) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onPluginConfig(plugins);
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onInterceptorConfig(Interceptors interceptors) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onInterceptorConfig(interceptors);
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onFixedInterceptorConfig(FixedInterceptors fixedInterceptors) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onFixedInterceptorConfig(fixedInterceptors);
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onHandlerConfig(JfinalHandlers handlers) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onHandlerConfig(handlers);
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onStartBefore() {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onStartBefore();
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onStart() {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onStart();
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onStartFinish() {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onStartFinish();
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onStop() {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onStop();
            }
            catch (Throwable ex) {
                log.error(ex.toString(), ex);
            }
        }
    }
}

