/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.core.log;

import com.jfinal.log.Log;
import com.jfinal.log.LogInfo;
import io.jboot.exception.JbootExceptionHolder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdkLogger
extends Log {
    private Logger log;
    private String clazzName;

    JdkLogger(Class<?> clazz) {
        this.log = Logger.getLogger(clazz.getName());
        this.clazzName = clazz.getName();
    }

    JdkLogger(String name) {
        this.log = Logger.getLogger(name);
        this.clazzName = name;
    }

    public void trace(String message) {
        this.log.logp(Level.FINEST, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    public void trace(String message, Throwable t) {
        this.log.logp(Level.FINEST, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    public void debug(String message) {
        this.log.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    public void debug(String message, Throwable t) {
        this.log.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    public void info(String message) {
        this.log.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    public void info(String message, Throwable t) {
        this.log.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    public void warn(String message) {
        this.log.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    public void warn(String message, Throwable t) {
        this.log.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    public void error(String message) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    public void error(String message, Throwable t) {
        JbootExceptionHolder.hold(message, t);
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    public void fatal(String message) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    public void fatal(String message, Throwable t) {
        JbootExceptionHolder.hold(message, t);
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    public boolean isTraceEnabled() {
        return this.log.isLoggable(Level.FINEST);
    }

    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.log.isLoggable(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    public void trace(String format, Object ... args) {
        if (this.isTraceEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.trace(li.message, li.throwable);
            } else {
                this.trace(String.format(format, args));
            }
        }
    }

    public void debug(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.debug(li.message, li.throwable);
            } else {
                this.debug(String.format(format, args));
            }
        }
    }

    public void info(String format, Object ... args) {
        if (this.isInfoEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.info(li.message, li.throwable);
            } else {
                this.info(String.format(format, args));
            }
        }
    }

    public void warn(String format, Object ... args) {
        if (this.isWarnEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.warn(li.message, li.throwable);
            } else {
                this.warn(String.format(format, args));
            }
        }
    }

    public void error(String format, Object ... args) {
        if (this.isErrorEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.error(li.message, li.throwable);
            } else {
                this.error(String.format(format, args));
            }
        }
    }

    public void fatal(String format, Object ... args) {
        if (this.isFatalEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.fatal(li.message, li.throwable);
            } else {
                this.fatal(String.format(format, args));
            }
        }
    }
}

