/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.core.spi;

import io.jboot.core.spi.JbootSpi;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.util.List;
import java.util.ServiceLoader;

public class JbootSpiLoader {
    public static <T> T load(Class<T> clazz, String spiName) {
        T returnObject = JbootSpiLoader.loadByServiceLoader(clazz, spiName);
        if (returnObject != null) {
            return returnObject;
        }
        if (StrUtil.isBlank((String)spiName)) {
            return null;
        }
        List<Class<T>> classes = ClassScanner.scanSubClass(clazz, true);
        if (classes == null || classes.isEmpty()) {
            return null;
        }
        for (Class<T> c : classes) {
            JbootSpi spiConfig = c.getAnnotation(JbootSpi.class);
            if (spiConfig == null || !spiName.equals(AnnotationUtil.get(spiConfig.value()))) continue;
            return ClassUtil.newInstance(c);
        }
        return null;
    }

    public static <T> T loadByServiceLoader(Class<T> clazz, String spiName) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz);
        for (T returnObject : serviceLoader) {
            if (spiName == null) {
                return returnObject;
            }
            JbootSpi spiConfig = returnObject.getClass().getAnnotation(JbootSpi.class);
            if (spiConfig == null || !spiName.equals(AnnotationUtil.get(spiConfig.value()))) continue;
            return returnObject;
        }
        return null;
    }
}

