/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db;

import com.jfinal.ext.kit.DateKit;
import com.jfinal.plugin.activerecord.Config;
import io.jboot.Jboot;
import io.jboot.utils.StrUtil;
import java.util.Date;
import java.util.regex.Matcher;

public class SqlDebugger {
    private static SqlDebugPrinter defaultPrinter;
    private static SqlDebugPrinter printer;

    public static SqlDebugPrinter getPrinter() {
        return printer;
    }

    public static void setPrinter(SqlDebugPrinter printer) {
        SqlDebugger.printer = printer;
    }

    public static void debug(Config config, String sql, Object ... paras) {
        if (!printer.isPrint(config, sql, paras)) {
            return;
        }
        if (paras != null) {
            for (Object value : paras) {
                if (value == null) {
                    sql = sql.replaceFirst("\\?", "null");
                    continue;
                }
                if (value instanceof Number) {
                    sql = sql.replaceFirst("\\?", value.toString());
                    continue;
                }
                if (value instanceof String && StrUtil.isNumeric((String)value)) {
                    sql = sql.replaceFirst("\\?", (String)value);
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                if (value instanceof Date) {
                    sb.append(DateKit.toStr((Date)((Date)value), (String)DateKit.timeStampPattern));
                } else {
                    sb.append(value.toString());
                }
                sb.append("'");
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(sb.toString()));
            }
        }
        printer.print(sql);
    }

    static {
        printer = defaultPrinter = new SqlDebugPrinter(){

            @Override
            public boolean isPrint(Config config, String sql, Object ... paras) {
                return Jboot.isDevMode();
            }

            @Override
            public void print(String sql) {
                System.out.println("\r\njboot exec sql >>> " + sql);
            }
        };
    }

    public static interface SqlDebugPrinter {
        public boolean isPrint(Config var1, String var2, Object ... var3);

        public void print(String var1);
    }
}

