/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.datasource;

import com.google.common.collect.Maps;
import io.jboot.app.config.JbootConfigUtil;
import io.jboot.db.datasource.DataSourceConfig;
import io.jboot.utils.StrUtil;
import java.util.Map;

public class DataSourceConfigManager {
    private static final String DATASOURCE_PREFIX = "jboot.datasource.";
    private static DataSourceConfigManager manager = new DataSourceConfigManager();
    private Map<String, DataSourceConfig> datasourceConfigs = Maps.newHashMap();

    public static DataSourceConfigManager me() {
        return manager;
    }

    private DataSourceConfigManager() {
        Map<String, DataSourceConfig> configMap = JbootConfigUtil.getConfigModels(DataSourceConfig.class, "jboot.datasource");
        for (Map.Entry<String, DataSourceConfig> entry : configMap.entrySet()) {
            DataSourceConfig config = entry.getValue();
            if (entry.getKey().equals("default") && StrUtil.isBlank((String)config.getName())) {
                config.setName("main");
            } else if (StrUtil.isBlank((String)config.getName())) {
                config.setName(entry.getKey());
            }
            this.addConfig(config);
        }
    }

    public void addConfig(DataSourceConfig config) {
        if (config == null || !config.isConfigOk()) {
            return;
        }
        this.datasourceConfigs.put(config.getName(), config);
    }

    public Map<String, DataSourceConfig> getDatasourceConfigs() {
        return this.datasourceConfigs;
    }

    public DataSourceConfig getMainDatasourceConfig() {
        return this.datasourceConfigs.get("main");
    }
}

