/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.dbpro;

import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbPro;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import io.jboot.db.SqlDebugger;
import io.jboot.db.dialect.JbootDialect;
import io.jboot.db.model.Columns;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class JbootDbPro
extends DbPro {
    public JbootDbPro() {
    }

    public JbootDbPro(String configName) {
        super(configName);
    }

    protected List<Record> find(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        SqlDebugger.debug(config, sql, paras);
        return super.find(config, conn, sql, paras);
    }

    protected <T> List<T> query(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        SqlDebugger.debug(config, sql, paras);
        return super.query(config, conn, sql, paras);
    }

    public int update(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        SqlDebugger.debug(config, sql, paras);
        return super.update(config, conn, sql, paras);
    }

    protected boolean save(Config config, Connection conn, String tableName, String primaryKey, Record record) throws SQLException {
        String[] pKeys = primaryKey.split(",");
        ArrayList paras = new ArrayList();
        StringBuilder sql = new StringBuilder();
        Dialect dialect = config.getDialect();
        dialect.forDbSave(tableName, pKeys, record, sql, paras);
        SqlDebugger.debug(config, sql.toString(), paras.toArray());
        PreparedStatement pst = dialect.isOracle() ? conn.prepareStatement(sql.toString(), pKeys) : conn.prepareStatement(sql.toString(), 1);
        dialect.fillStatement(pst, paras);
        int result = pst.executeUpdate();
        dialect.getRecordGeneratedKey(pst, record, pKeys);
        if (pst != null) {
            try {
                pst.close();
            }
            catch (SQLException e) {
                throw new ActiveRecordException((Throwable)e);
            }
        }
        return result >= 1;
    }

    public List<Record> find(String tableName, Columns columns) {
        return this.find(tableName, columns, null, null);
    }

    public List<Record> find(String tableName, Columns columns, String orderBy) {
        return this.find(tableName, columns, orderBy, null);
    }

    public List<Record> find(String tableName, Columns columns, Object limit) {
        return this.find(tableName, columns, null, limit);
    }

    public List<Record> find(String tableName, Columns columns, String orderBy, Object limit) {
        JbootDialect dialect = (JbootDialect)this.getConfig().getDialect();
        String sql = dialect.forFindByColumns(null, tableName, "*", columns.getList(), orderBy, limit);
        return columns.isEmpty() ? this.find(sql) : this.find(sql, columns.getValueArray());
    }

    public int delete(String tableName, Columns columns) {
        JbootDialect dialect = (JbootDialect)this.getConfig().getDialect();
        String sql = dialect.forDeleteByColumns(null, tableName, columns.getList());
        return columns.isEmpty() ? this.delete(sql) : this.delete(sql, columns.getValueArray());
    }
}

