/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.dialect;

import com.jfinal.plugin.activerecord.dialect.PostgreSqlDialect;
import io.jboot.db.dialect.JbootDialect;
import io.jboot.db.model.Column;
import io.jboot.db.model.Join;
import io.jboot.db.model.SqlBuilder;
import io.jboot.exception.JbootException;
import java.util.List;

public class JbootPostgreSqlDialect
extends PostgreSqlDialect
implements JbootDialect {
    @Override
    public String forFindByColumns(List<Join> joins, String table, String loadColumns, List<Column> columns, String orderBy, Object limit) {
        StringBuilder sqlBuilder = SqlBuilder.forFindByColumns(joins, table, loadColumns, columns, orderBy, '\"');
        if (limit == null) {
            return sqlBuilder.toString();
        }
        if (limit instanceof Number) {
            sqlBuilder.append(" limit ").append(limit).append(" offset ").append(0);
            return sqlBuilder.toString();
        }
        if (limit instanceof String && limit.toString().contains(",")) {
            String[] startAndEnd = limit.toString().split(",");
            String start = startAndEnd[0];
            String end = startAndEnd[1];
            sqlBuilder.append(" limit ").append(end).append(" offset ").append(start);
            return sqlBuilder.toString();
        }
        throw new JbootException("sql limit is error!,limit must is Number of String like \"0,10\"");
    }

    @Override
    public String forFindCountByColumns(List<Join> joins, String table, List<Column> columns) {
        return SqlBuilder.forFindCountByColumns(joins, table, columns, '\"');
    }

    @Override
    public String forDeleteByColumns(List<Join> joins, String table, List<Column> columns) {
        return SqlBuilder.forDeleteByColumns(joins, table, columns, '\"');
    }

    @Override
    public String forPaginateSelect(String loadColumns) {
        return "SELECT " + loadColumns;
    }

    @Override
    public String forPaginateFrom(List<Join> joins, String table, List<Column> columns, String orderBy) {
        return SqlBuilder.forPaginateFrom(joins, table, columns, orderBy, '\"');
    }
}

