/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.model;

import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import io.jboot.db.SqlDebugger;
import io.jboot.db.dialect.JbootDialect;
import io.jboot.db.model.Column;
import io.jboot.db.model.Columns;
import io.jboot.db.model.JbootModelConfig;
import io.jboot.db.model.Join;
import io.jboot.db.model.Joiner;
import io.jboot.db.model.Util;
import io.jboot.exception.JbootException;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class JbootModel<M extends JbootModel<M>>
extends Model<M> {
    private static final Log LOG = Log.getLog(JbootModel.class);
    private static final String DATASOURCE_CACHE_PREFIX = "__ds__";
    private static JbootModelConfig config = JbootModelConfig.getConfig();
    private static String column_created = config.getColumnCreated();
    private static String column_modified = config.getColumnModified();
    private static boolean idCacheEnable = config.isIdCacheEnable();
    protected List<Join> joins = null;
    String datasourceName = null;
    private transient Table table;
    private transient String[] primaryKeys;
    private transient Class<?> primaryType;

    public Joiner<M> leftJoin(String table) {
        return this.joining(" LEFT JOIN ", table, true);
    }

    public Joiner<M> leftJoinIf(String table, boolean condition) {
        return this.joining(" LEFT JOIN ", table, condition);
    }

    public Joiner<M> rightJoin(String table) {
        return this.joining(" RIGHT JOIN ", table, true);
    }

    public Joiner<M> rightJoinIf(String table, boolean condition) {
        return this.joining(" RIGHT JOIN ", table, condition);
    }

    public Joiner<M> innerJoin(String table) {
        return this.joining(" INNER JOIN ", table, true);
    }

    public Joiner<M> innerJoinIf(String table, boolean condition) {
        return this.joining(" INNER JOIN ", table, condition);
    }

    public Joiner<M> fullJoin(String table) {
        return this.joining(" FULL JOIN ", table, true);
    }

    public Joiner<M> fullJoinIf(String table, boolean condition) {
        return this.joining(" FULL JOIN ", table, condition);
    }

    protected Joiner<M> joining(String type, String table, boolean condition) {
        JbootModel model;
        JbootModel<M> jbootModel = model = this.joins == null ? ((JbootModel)((Object)this.copy())).superUse(this.datasourceName) : this;
        if (model.joins == null) {
            model.joins = new LinkedList<Join>();
        }
        Join join = new Join(type, table, condition);
        model.joins.add(join);
        return new Joiner<JbootModel>(model, join);
    }

    public M copy() {
        JbootModel m = null;
        try {
            m = (JbootModel)((Object)this._getUsefulClass().newInstance());
            m.put(this._getAttrs());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return (M)((Object)m);
    }

    public M copyModel() {
        JbootModel m = null;
        try {
            m = (JbootModel)((Object)this._getUsefulClass().newInstance());
            Table table = this._getTable(true);
            Set attrKeys = table.getColumnTypeMap().keySet();
            for (String attrKey : attrKeys) {
                Object o = this.get(attrKey);
                if (o == null) continue;
                m.set(attrKey, o);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return (M)((Object)m);
    }

    public M use(String configName) {
        return this.use(configName, true);
    }

    public M useFirst(String ... configNames) {
        if (configNames == null || configNames.length == 0) {
            throw new IllegalArgumentException("configNames must not empty.");
        }
        for (String name : configNames) {
            M newDao = this.use(name, false);
            if (newDao == null) continue;
            return newDao;
        }
        return (M)((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private M use(String configName, boolean validateExist) {
        JbootModel<M> newDao = (JbootModel)((Object)this.get(DATASOURCE_CACHE_PREFIX + configName));
        if (newDao == null) {
            String string = configName.intern();
            synchronized (string) {
                newDao = (JbootModel)((Object)this.get(DATASOURCE_CACHE_PREFIX + configName));
                if (newDao == null) {
                    newDao = ((JbootModel)((Object)this.copy())).superUse(configName);
                    if (newDao._getConfig() == null) {
                        if (validateExist) {
                            throw new JbootIllegalConfigException("the datasource \"" + configName + "\" not config well, please config it.");
                        }
                        return null;
                    }
                    newDao.datasourceName = configName;
                    this.put(DATASOURCE_CACHE_PREFIX + configName, newDao);
                }
            }
        }
        return (M)((Object)newDao);
    }

    M superUse(String configName) {
        return (M)((Object)((JbootModel)super.use(configName)));
    }

    public boolean saveOrUpdate() {
        if (null == this._getIdValue()) {
            return this.save();
        }
        return this.update();
    }

    public boolean save() {
        Object value;
        String[] pkeys;
        if (this._hasColumn(column_created) && this.get(column_created) == null) {
            this.set(column_created, new Date());
        }
        if ((pkeys = this._getPrimaryKeys()) != null && pkeys.length == 1 && this.get(pkeys[0]) == null && (value = config.getPrimarykeyValueGenerator().genValue(this, this._getPrimaryType())) != null) {
            this.set(pkeys[0], value);
        }
        this.filter(0);
        Config config = this._getConfig();
        Table table = this._getTable();
        StringBuilder sql = new StringBuilder();
        ArrayList paras = new ArrayList();
        Dialect dialect = this._getConfig().getDialect();
        dialect.forModelSave(table, this._getAttrs(), sql, paras);
        Connection conn = null;
        PreparedStatement pst = null;
        int result = 0;
        try {
            conn = config.getConnection();
            pst = dialect.isOracle() ? conn.prepareStatement(sql.toString(), table.getPrimaryKey()) : conn.prepareStatement(sql.toString(), 1);
            dialect.fillStatement(pst, paras);
            result = pst.executeUpdate();
            dialect.getModelGeneratedKey((Model)this, pst, table);
            this._getModifyFlag().clear();
            boolean bl = result >= 1;
            return bl;
        }
        catch (Exception e) {
            throw new ActiveRecordException((Throwable)e);
        }
        finally {
            SqlDebugger.debug(config, sql.toString(), paras.toArray());
            config.close((Statement)pst, conn);
        }
    }

    protected void filter(int filterBy) {
        config.getFilter().filter(this, filterBy);
    }

    public M findById(Object idValue) {
        if (idValue == null) {
            return null;
        }
        return (M)(idCacheEnable ? this.loadByCache(idValue) : (JbootModel)super.findById(idValue));
    }

    public M findByIds(Object ... idValues) {
        if (idValues == null) {
            return null;
        }
        if (idValues.length != this._getPrimaryKeys().length) {
            throw new IllegalArgumentException("idValues.length != _getPrimaryKeys().length");
        }
        return (M)(idCacheEnable ? this.loadByCache(idValues) : (JbootModel)super.findByIds(idValues));
    }

    protected M loadByCache(Object ... idValues) {
        try {
            return (M)((Object)((JbootModel)((Object)config.getIdCache().get(this._getTableName(), this.buildIdCacheKey(idValues), () -> (JbootModel)JbootModel.super.findByIds(idValues), config.getIdCacheTime()))));
        }
        catch (Exception ex) {
            LOG.error(ex.toString(), (Throwable)ex);
            this.safeDeleteCache(idValues);
            return (M)((Object)((JbootModel)JbootModel.super.findByIds(idValues)));
        }
    }

    protected void safeDeleteCache(Object ... idValues) {
        try {
            config.getIdCache().remove(this._getTableName(), this.buildIdCacheKey(idValues));
        }
        catch (Exception ex) {
            LOG.error("remove cache exception by name [" + this._getTableName() + "] and key [" + this.buildIdCacheKey(idValues) + "]", (Throwable)ex);
        }
    }

    public boolean delete() {
        boolean success = super.delete();
        if (success && idCacheEnable) {
            this.deleteIdCache();
        }
        return success;
    }

    public boolean deleteById(Object idValue) {
        boolean success = super.deleteById(idValue);
        if (success && idCacheEnable) {
            this.deleteIdCacheById(idValue);
        }
        return success;
    }

    public boolean deleteByIds(Object ... idValues) {
        boolean success = super.deleteByIds(idValues);
        if (success && idCacheEnable) {
            this.deleteIdCacheById(idValues);
        }
        return success;
    }

    public boolean deleteByColumn(Column column) {
        return this.deleteByColumns(Arrays.asList(column));
    }

    public boolean deleteByColumns(Columns columns) {
        return this.deleteByColumns(columns.getList());
    }

    public boolean deleteByColumns(List<Column> columns) {
        String sql = this._getDialect().forDeleteByColumns(this.joins, this._getTableName(), columns);
        return Db.use((String)this._getConfig().getName()).update(sql, Util.getValueArray(columns)) >= 1;
    }

    public boolean batchDeleteByIds(Object ... idValues) {
        if (idValues == null || idValues.length == 0) {
            return false;
        }
        boolean success = this.deleteByColumns(Columns.create().orEqs(this._getPrimaryKey(), idValues));
        if (success && idCacheEnable) {
            for (Object id : idValues) {
                this.deleteIdCacheById(id);
            }
        }
        return success;
    }

    public boolean update() {
        boolean success;
        if (this._hasColumn(column_modified)) {
            this.set(column_modified, new Date());
        }
        if ((success = super.update()) && idCacheEnable) {
            this.deleteIdCache();
        }
        return success;
    }

    public void deleteIdCache() {
        if (this._getPrimaryKeys().length == 1) {
            Object idValue = this.get(this._getPrimaryKey());
            this.deleteIdCacheById(idValue);
        } else {
            Object[] idvalues = new Object[this._getPrimaryKeys().length];
            for (int i = 0; i < idvalues.length; ++i) {
                idvalues[i] = this.get(this._getPrimaryKeys()[i]);
            }
            this.deleteIdCacheById(idvalues);
        }
    }

    public void deleteIdCacheById(Object ... idvalues) {
        this.safeDeleteCache(idvalues);
    }

    protected String buildIdCacheKey(Object ... idValues) {
        if (idValues == null || idValues.length == 0) {
            return null;
        }
        if (idValues.length == 1) {
            return idValues[0].toString();
        }
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < idValues.length; ++i) {
            key.append(idValues[i]);
            if (i >= idValues.length - 1) continue;
            key.append(":");
        }
        return key.toString();
    }

    protected JbootDialect _getDialect() {
        Config config = this._getConfig();
        if (config == null) {
            throw new JbootException(String.format("class %s can not mapping to database table, maybe cannot connect to database. ", this._getUsefulClass().getName()));
        }
        return (JbootDialect)config.getDialect();
    }

    public M findFirstByColumn(String column, Object value) {
        return this.findFirstByColumn(Column.create(column, value));
    }

    public M findFirstByColumn(String column, Object value, String orderBy) {
        return this.findFirstByColumn(Column.create(column, value), orderBy);
    }

    public M findFirstByColumn(Column column) {
        return this.findFirstByColumns(Columns.create(column));
    }

    public M findFirstByColumn(Column column, String orderBy) {
        return this.findFirstByColumns(Columns.create(column), orderBy);
    }

    public M findFirstByColumns(Columns columns) {
        return this.findFirstByColumns(columns, null);
    }

    public M findFirstByColumns(Columns columns, String orderby) {
        return this.findFirstByColumns(columns, orderby, "*");
    }

    public M findFirstByColumns(Columns columns, String orderby, String loadColumns) {
        String sql = this._getDialect().forFindByColumns(this.joins, this._getTableName(), loadColumns, columns.getList(), orderby, 1);
        return (M)((Object)(columns.isEmpty() ? (JbootModel)this.findFirst(sql) : (JbootModel)this.findFirst(sql, columns.getValueArray())));
    }

    public List<M> findListByIds(Object ... ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        ArrayList<Model> list = new ArrayList<Model>();
        for (Object id : ids) {
            if (id.getClass() == int[].class) {
                this.findListByIds((List<M>)list, (int[])id);
                continue;
            }
            if (id.getClass() == long[].class) {
                this.findListByIds(list, (long[])id);
                continue;
            }
            if (id.getClass() == short[].class) {
                this.findListByIds((List<M>)list, (short[])id);
                continue;
            }
            Model model = this.findById(id);
            if (model == null) continue;
            list.add(model);
        }
        return list;
    }

    private void findListByIds(List<M> list, int[] ids) {
        for (int id : ids) {
            Model model = this.findById(id);
            if (model == null) continue;
            list.add(model);
        }
    }

    private void findListByIds(List<M> list, long[] ids) {
        for (long id : ids) {
            Model model = this.findById(id);
            if (model == null) continue;
            list.add(model);
        }
    }

    private void findListByIds(List<M> list, short[] ids) {
        for (short id : ids) {
            Model model = this.findById(id);
            if (model == null) continue;
            list.add(model);
        }
    }

    public List<M> findListByColumn(String column, Object value) {
        return this.findListByColumn(Column.create(column, value), null, null);
    }

    public List<M> findListByColumn(Column column) {
        return this.findListByColumn(column, null, null);
    }

    public List<M> findListByColumn(String column, Object value, Integer count) {
        return this.findListByColumn(Column.create(column, value), null, count);
    }

    public List<M> findListByColumn(Column column, Integer count) {
        return this.findListByColumn(column, null, count);
    }

    public List<M> findListByColumn(String column, Object value, String orderBy) {
        return this.findListByColumn(Column.create(column, value), orderBy, null);
    }

    public List<M> findListByColumn(Column column, String orderby) {
        return this.findListByColumn(column, orderby, null);
    }

    public List<M> findListByColumn(String column, Object value, String orderBy, Integer count) {
        return this.findListByColumn(Column.create(column, value), orderBy, count);
    }

    public List<M> findListByColumn(Column column, String orderBy, Integer count) {
        return this.findListByColumns(Columns.create(column), orderBy, count);
    }

    public List<M> findListByColumns(List<Column> columns) {
        return this.findListByColumns(columns, null, null);
    }

    public List<M> findListByColumns(List<Column> columns, String orderBy) {
        return this.findListByColumns(columns, orderBy, null);
    }

    public List<M> findListByColumns(List<Column> columns, Integer count) {
        return this.findListByColumns(columns, null, count);
    }

    public List<M> findListByColumns(List<Column> columns, String orderBy, Integer count) {
        return this.findListByColumns(Columns.create(columns), orderBy, count);
    }

    public List<M> findListByColumns(Columns columns) {
        return this.findListByColumns(columns, null, null);
    }

    public List<M> findListByColumns(Columns columns, String orderBy) {
        return this.findListByColumns(columns, orderBy, null);
    }

    public List<M> findListByColumns(Columns columns, Integer count) {
        return this.findListByColumns(columns, null, count);
    }

    public List<M> findListByColumns(Columns columns, String orderBy, Integer count) {
        return this.findListByColumns(columns, orderBy, count, "*");
    }

    public List<M> findListByColumns(Columns columns, String orderBy, Integer count, String loadColumns) {
        String sql = this._getDialect().forFindByColumns(this.joins, this._getTableName(), loadColumns, columns.getList(), orderBy, count);
        return columns.isEmpty() ? this.find(sql) : this.find(sql, columns.getValueArray());
    }

    public Page<M> paginate(int pageNumber, int pageSize) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(), null);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String orderBy) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(), orderBy);
    }

    public Page<M> paginateByColumn(int pageNumber, int pageSize, Column column) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(column), null);
    }

    public Page<M> paginateByColumn(int pageNumber, int pageSize, Column column, String orderBy) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(column), orderBy);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, Columns columns) {
        return this.paginateByColumns(pageNumber, pageSize, columns, null);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, List<Column> columns) {
        return this.paginateByColumns(pageNumber, pageSize, columns, null);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, List<Column> columns, String orderBy) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(columns), orderBy);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, Columns columns, String orderBy) {
        return this.paginateByColumns(pageNumber, pageSize, columns, orderBy, "*");
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, Columns columns, String orderBy, String loadColumns) {
        String selectPartSql = this._getDialect().forPaginateSelect(loadColumns);
        String fromPartSql = this._getDialect().forPaginateFrom(this.joins, this._getTableName(), columns.getList(), orderBy);
        return columns.isEmpty() ? this.paginate(pageNumber, pageSize, selectPartSql, fromPartSql) : this.paginate(pageNumber, pageSize, selectPartSql, fromPartSql, columns.getValueArray());
    }

    public long findCountByColumn(Column column) {
        return this.findCountByColumns(Columns.create(column));
    }

    public long findCountByColumns(Columns columns) {
        String sql = this._getDialect().forFindCountByColumns(this.joins, this._getTableName(), columns.getList());
        Long value = Db.use((String)this._getConfig().getName()).queryLong(sql, Util.getValueArray(columns.getList()));
        return value == null ? 0L : value;
    }

    public <T> T _getIdValue() {
        return (T)this.get(this._getPrimaryKey());
    }

    public <T> T[] _getIdValues(Class<T> clazz) {
        String[] pkeys = this._getPrimaryKeys();
        Object[] values = (Object[])Array.newInstance(clazz, pkeys.length);
        int i = 0;
        for (String key : pkeys) {
            values[i++] = this.get(key);
        }
        return values;
    }

    public String _getTableName() {
        return this._getTable(true).getName();
    }

    public Table _getTable() {
        return this._getTable(false);
    }

    public Table _getTable(boolean validateMapping) {
        if (this.table == null) {
            this.table = super._getTable();
            if (this.table == null && validateMapping) {
                throw new JbootException(String.format("class %s can not mapping to database table,maybe application cannot connect to database. ", this._getUsefulClass().getName()));
            }
        }
        return this.table;
    }

    public String _getPrimaryKey() {
        return this._getPrimaryKeys()[0];
    }

    public String[] _getPrimaryKeys() {
        if (this.primaryKeys != null) {
            return this.primaryKeys;
        }
        this.primaryKeys = this._getTable(true).getPrimaryKey();
        if (this.primaryKeys == null) {
            throw new JbootException(String.format("primaryKeys == null in [%s]", ((Object)((Object)this)).getClass()));
        }
        return this.primaryKeys;
    }

    protected Class<?> _getPrimaryType() {
        if (this.primaryType == null) {
            this.primaryType = this._getTable(true).getColumnType(this._getPrimaryKey());
        }
        return this.primaryType;
    }

    protected boolean _hasColumn(String columnLabel) {
        return this._getTable(true).hasColumnLabel(columnLabel);
    }

    protected List<M> find(Config config, String sql, Object ... paras) {
        SqlDebugger.debug(config, sql, paras);
        return super.find(config, sql, paras);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof JbootModel)) {
            return false;
        }
        if (this._getTable(false) == null) {
            return this == o;
        }
        Object id = ((JbootModel)((Object)o))._getIdValue();
        return id != null && id.equals(this._getIdValue());
    }

    public M preventXssAttack() {
        String[] attrNames;
        for (String attrName : attrNames = this._getAttrNames()) {
            Object value = this.get(attrName);
            if (value == null || !(value instanceof String)) continue;
            this.set(attrName, StrUtil.escapeHtml((String)value));
        }
        return (M)((Object)this);
    }

    public M preventXssAttack(String ... ignoreAttrs) {
        String[] attrNames;
        for (String attrName : attrNames = this._getAttrNames()) {
            Object value = this.get(attrName);
            if (value == null || !(value instanceof String)) continue;
            boolean isIgnoreAttr = false;
            for (String ignoreAttr : ignoreAttrs) {
                if (!attrName.equals(ignoreAttr)) continue;
                isIgnoreAttr = true;
                break;
            }
            if (isIgnoreAttr) continue;
            this.set(attrName, StrUtil.escapeHtml((String)value));
        }
        return (M)((Object)this);
    }
}

