/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.model;

import io.jboot.Jboot;
import io.jboot.app.config.annotation.ConfigModel;
import io.jboot.components.cache.JbootCache;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.components.cache.JbootCacheManager;
import io.jboot.db.model.JbootModelFilter;
import io.jboot.db.model.PrimarykeyValueGenerator;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;

@ConfigModel(prefix="jboot.model")
public class JbootModelConfig {
    private String scanPackage;
    private String unscanPackage;
    private String columnCreated = "created";
    private String columnModified = "modified";
    private int idCacheTime = 3600;
    private String filterClass;
    private String primarykeyValueGeneratorClass;
    private boolean idCacheEnable = true;
    private String idCacheType = Jboot.config(JbootCacheConfig.class).getType();
    private JbootModelFilter filter;
    private PrimarykeyValueGenerator primarykeyValueGenerator;
    private static JbootModelConfig config;
    private JbootCache idCache;

    public String getScanPackage() {
        return this.scanPackage;
    }

    public void setScanPackage(String scanPackage) {
        this.scanPackage = scanPackage;
    }

    public String getUnscanPackage() {
        return this.unscanPackage;
    }

    public void setUnscanPackage(String unscanPackage) {
        this.unscanPackage = unscanPackage;
    }

    public String getColumnCreated() {
        return this.columnCreated;
    }

    public void setColumnCreated(String columnCreated) {
        this.columnCreated = columnCreated;
    }

    public String getColumnModified() {
        return this.columnModified;
    }

    public void setColumnModified(String columnModified) {
        this.columnModified = columnModified;
    }

    public int getIdCacheTime() {
        return this.idCacheTime;
    }

    public void setIdCacheTime(int idCacheTime) {
        this.idCacheTime = idCacheTime;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public String getPrimarykeyValueGeneratorClass() {
        return this.primarykeyValueGeneratorClass;
    }

    public void setPrimarykeyValueGeneratorClass(String primarykeyValueGeneratorClass) {
        this.primarykeyValueGeneratorClass = primarykeyValueGeneratorClass;
    }

    public boolean isIdCacheEnable() {
        return this.idCacheEnable;
    }

    public void setIdCacheEnable(boolean idCacheEnable) {
        this.idCacheEnable = idCacheEnable;
    }

    public String getIdCacheType() {
        return this.idCacheType;
    }

    public void setIdCacheType(String idCacheType) {
        this.idCacheType = idCacheType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JbootModelFilter getFilter() {
        if (this.filter == null) {
            if (StrUtil.isNotBlank(this.filterClass)) {
                JbootModelConfig jbootModelConfig = this;
                synchronized (jbootModelConfig) {
                    if (this.filter == null) {
                        this.filter = (JbootModelFilter)ClassUtil.newInstance(this.filterClass);
                    }
                }
            } else {
                this.filter = JbootModelFilter.DEFAULT;
            }
        }
        return this.filter;
    }

    public void setFilter(JbootModelFilter filter) {
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimarykeyValueGenerator getPrimarykeyValueGenerator() {
        if (this.primarykeyValueGenerator == null) {
            if (StrUtil.isNotBlank(this.primarykeyValueGeneratorClass)) {
                JbootModelConfig jbootModelConfig = this;
                synchronized (jbootModelConfig) {
                    if (this.primarykeyValueGenerator == null) {
                        this.primarykeyValueGenerator = (PrimarykeyValueGenerator)ClassUtil.newInstance(this.primarykeyValueGeneratorClass);
                    }
                }
            } else {
                this.primarykeyValueGenerator = PrimarykeyValueGenerator.DEFAULT;
            }
        }
        return this.primarykeyValueGenerator;
    }

    public void setPrimarykeyValueGenerator(PrimarykeyValueGenerator primarykeyValueGenerator) {
        this.primarykeyValueGenerator = primarykeyValueGenerator;
    }

    public static JbootModelConfig getConfig() {
        if (config == null) {
            config = Jboot.config(JbootModelConfig.class);
        }
        return config;
    }

    public JbootCache getIdCache() {
        if (this.idCache == null) {
            this.idCache = JbootCacheManager.me().getCache(this.idCacheType);
        }
        return this.idCache;
    }

    public void setIdCache(JbootCache idCache) {
        this.idCache = idCache;
    }
}

