/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.model;

import io.jboot.db.model.Column;
import io.jboot.db.model.Group;
import io.jboot.db.model.Join;
import io.jboot.db.model.Or;
import io.jboot.db.model.SqlPart;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.StrUtil;
import java.util.List;

public class SqlBuilder {
    private static final String OR = " OR ";
    private static final String AND = " AND ";

    public static void buildMysqlWhereSql(StringBuilder sqlBuilder, List<Column> columns) {
        SqlBuilder.buildWhereSql(sqlBuilder, columns, '`');
    }

    public static String forDeleteByColumns(List<Join> joins, String table, List<Column> columns, char separator) {
        StringBuilder sql = new StringBuilder(45);
        sql.append("DELETE FROM ").append(separator).append(table).append(separator);
        SqlBuilder.buildJoinSql(sql, joins, separator);
        SqlBuilder.buildWhereSql(sql, columns, separator);
        return sql.toString();
    }

    public static void buildWhereSql(StringBuilder sqlBuilder, List<Column> columns, char separator) {
        SqlBuilder.buildWhereSql(sqlBuilder, columns, separator, true);
    }

    public static void buildWhereSql(StringBuilder sqlBuilder, List<Column> columns, char separator, boolean withWhereKeyword) {
        if (ArrayUtil.isNullOrEmpty(columns)) {
            return;
        }
        StringBuilder whereSqlBuilder = new StringBuilder();
        SqlBuilder.buildByColumns(whereSqlBuilder, columns, separator);
        String whereSql = whereSqlBuilder.toString();
        if (StrUtil.isNotBlank(whereSql)) {
            sqlBuilder.append(withWhereKeyword ? " WHERE " : "").append(whereSql);
        }
    }

    private static void buildByColumns(StringBuilder sqlBuilder, List<Column> columns, char separator) {
        for (int i = 0; i < columns.size(); ++i) {
            Column before = i > 0 ? columns.get(i - 1) : null;
            Column curent = columns.get(i);
            if (curent instanceof Or) continue;
            if (curent instanceof SqlPart) {
                SqlBuilder.appendSqlPartLogic(sqlBuilder, before, (SqlPart)curent);
                continue;
            }
            if (curent instanceof Group) {
                SqlBuilder.appendGroupLogic(sqlBuilder, before, (Group)curent, separator);
                continue;
            }
            if ("IN".equals(curent.getLogic()) || "NOT IN".equals(curent.getLogic())) {
                SqlBuilder.appendLinkString(sqlBuilder, before);
                SqlBuilder.appendInLogic(sqlBuilder, curent, separator);
                continue;
            }
            if ("BETWEEN".equals(curent.getLogic()) || "NOT BETWEEN".equals(curent.getLogic())) {
                SqlBuilder.appendLinkString(sqlBuilder, before);
                SqlBuilder.appendBetweenLogic(sqlBuilder, curent, separator);
                continue;
            }
            SqlBuilder.appendLinkString(sqlBuilder, before);
            SqlBuilder.appendColumnName(sqlBuilder, curent, separator);
            if (!curent.hasPara()) continue;
            sqlBuilder.append('?');
        }
    }

    private static void appendSqlPartLogic(StringBuilder sqlBuilder, Column before, SqlPart sqlPart) {
        if (!sqlPart.isWithoutLink()) {
            SqlBuilder.appendLinkString(sqlBuilder, before);
        }
        sqlBuilder.append(' ').append(sqlPart.getSql()).append(' ');
    }

    private static void appendColumnName(StringBuilder sqlBuilder, Column column, char separator) {
        if (column.getName().contains(".")) {
            sqlBuilder.append(column.getName()).append(' ').append(column.getLogic()).append(' ');
        } else {
            sqlBuilder.append(separator).append(column.getName()).append(separator).append(' ').append(column.getLogic()).append(' ');
        }
    }

    private static void appendLinkString(StringBuilder sqlBuilder, Column before) {
        if (sqlBuilder.length() == 0 || before == null) {
            return;
        }
        sqlBuilder.append(before instanceof Or ? OR : AND);
    }

    public static void appendGroupLogic(StringBuilder sqlBuilder, Column before, Group group, char separator) {
        List<Column> columns = group.getColumns().getList();
        if (ArrayUtil.isNullOrEmpty(columns)) {
            return;
        }
        StringBuilder groupSqlBuilder = new StringBuilder();
        SqlBuilder.buildByColumns(groupSqlBuilder, columns, separator);
        String groupSql = groupSqlBuilder.toString();
        if (StrUtil.isNotBlank(groupSql)) {
            SqlBuilder.appendLinkString(sqlBuilder, before);
            sqlBuilder.append('(');
            sqlBuilder.append(groupSql);
            sqlBuilder.append(')');
        }
    }

    public static void appendInLogic(StringBuilder sqlBuilder, Column column, char separator) {
        SqlBuilder.appendColumnName(sqlBuilder, column, separator);
        sqlBuilder.append('(');
        Object[] values = (Object[])column.getValue();
        int paraCount = 0;
        for (Object v : values) {
            if (v.getClass() == int[].class) {
                paraCount += ((int[])v).length;
                continue;
            }
            if (v.getClass() == long[].class) {
                paraCount += ((long[])v).length;
                continue;
            }
            if (v.getClass() == short[].class) {
                paraCount += ((short[])v).length;
                continue;
            }
            ++paraCount;
        }
        for (int i = 0; i < paraCount; ++i) {
            sqlBuilder.append('?');
            if (i == paraCount - 1) continue;
            sqlBuilder.append(',');
        }
        sqlBuilder.append(')');
    }

    public static void appendBetweenLogic(StringBuilder sqlBuilder, Column column, char separator) {
        sqlBuilder.append(separator).append(column.getName()).append(separator).append(' ').append(column.getLogic());
        sqlBuilder.append(" ? AND ?");
    }

    public static StringBuilder forFindByColumns(List<Join> joins, String table, String loadColumns, List<Column> columns, String orderBy, char separator) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT ");
        sqlBuilder.append(loadColumns).append(" FROM ").append(separator).append(table).append(separator);
        SqlBuilder.buildJoinSql(sqlBuilder, joins, separator);
        SqlBuilder.buildWhereSql(sqlBuilder, columns, separator);
        if (StrUtil.isNotBlank(orderBy)) {
            sqlBuilder.append(" ORDER BY ").append(orderBy);
        }
        return sqlBuilder;
    }

    public static String forPaginateFrom(List<Join> joins, String table, List<Column> columns, String orderBy, char separator) {
        StringBuilder sqlBuilder = new StringBuilder(" FROM ").append(separator).append(table).append(separator);
        SqlBuilder.buildJoinSql(sqlBuilder, joins, separator);
        SqlBuilder.buildWhereSql(sqlBuilder, columns, separator);
        if (StrUtil.isNotBlank(orderBy)) {
            sqlBuilder.append(" ORDER BY ").append(orderBy);
        }
        return sqlBuilder.toString();
    }

    private static void buildJoinSql(StringBuilder sqlBuilder, List<Join> joins, char separator) {
        if (joins == null || joins.isEmpty()) {
            return;
        }
        for (Join join : joins) {
            if (!join.isEffective()) continue;
            sqlBuilder.append(join.getType()).append(separator).append(join.getTable()).append(separator);
            if (StrUtil.isNotBlank(join.getAs())) {
                sqlBuilder.append(" AS ").append(join.getAs());
            }
            sqlBuilder.append(" ON ").append(join.getOn());
        }
    }

    public static String forFindCountByColumns(List<Join> joins, String table, List<Column> columns, char separator) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT count(*) FROM ").append(separator).append(table).append(separator);
        SqlBuilder.buildJoinSql(sqlBuilder, joins, separator);
        SqlBuilder.buildWhereSql(sqlBuilder, columns, separator);
        return sqlBuilder.toString();
    }
}

