/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.jwt;

import com.jfinal.kit.JsonKit;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.exception.JbootException;
import io.jboot.support.jwt.JwtConfig;
import io.jboot.utils.StrUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class JwtManager {
    private static final JwtManager me = new JwtManager();
    private static final Log LOG = Log.getLog(JwtManager.class);
    private ThreadLocal<Map> jwtThreadLocal = new ThreadLocal();
    private JwtConfig config;

    public static JwtManager me() {
        return me;
    }

    public void holdJwts(Map map) {
        this.jwtThreadLocal.set(map);
    }

    public void releaseJwts() {
        this.jwtThreadLocal.remove();
    }

    public <T> T getPara(String key) {
        Map map = this.jwtThreadLocal.get();
        return map == null ? null : (T)map.get(key);
    }

    public Map getParas() {
        return this.jwtThreadLocal.get();
    }

    public String getHttpHeaderName() {
        return this.getConfig().getHttpHeaderName();
    }

    public String getHttpParameterKey() {
        return this.getConfig().getHttpParameterKey();
    }

    public Map parseJwtToken(String token) {
        SecretKey secretKey = this.generalKey();
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey((Key)secretKey).parseClaimsJws(token).getBody();
            String jsonString = claims.getSubject();
            if (StrUtil.isNotBlank(jsonString)) {
                return (Map)JsonKit.parse((String)jsonString, HashMap.class);
            }
        }
        catch (MalformedJwtException | SignatureException e) {
            LOG.error("do not trast the jwt!", e);
        }
        catch (ExpiredJwtException e) {
            LOG.error("jwt is expired!", (Throwable)e);
        }
        catch (Throwable ex) {
            LOG.error("jwt parseJwtToken error, return null.");
        }
        return null;
    }

    public String createJwtToken(Map map) {
        if (!this.getConfig().isConfigOk()) {
            throw new JbootException("can not create jwt, please config jboot.web.jwt.secret in jboot.properties.");
        }
        SecretKey secretKey = this.generalKey();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        map.put("isuuedAt", nowMillis);
        String subject = JsonKit.toJson((Object)map);
        JwtBuilder builder = Jwts.builder().setIssuedAt(now).setSubject(subject).signWith(signatureAlgorithm, (Key)secretKey);
        if (this.getConfig().getValidityPeriod() > 0L) {
            long expMillis = nowMillis + this.getConfig().getValidityPeriod();
            builder.setExpiration(new Date(expMillis));
        }
        return builder.compact();
    }

    private SecretKey generalKey() {
        byte[] encodedKey = DatatypeConverter.parseBase64Binary((String)this.getConfig().getSecret());
        SecretKeySpec key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }

    public JwtConfig getConfig() {
        if (this.config == null) {
            this.config = Jboot.config(JwtConfig.class);
        }
        return this.config;
    }
}

