/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.support.metric.JbootMetricConfig;
import io.jboot.support.metric.JbootMetricReporter;
import io.jboot.support.metric.reporter.console.JbootConsoleReporter;
import io.jboot.support.metric.reporter.csv.CSVReporter;
import io.jboot.support.metric.reporter.elasticsearch.ElasticsearchReporter;
import io.jboot.support.metric.reporter.ganglia.GangliaReporter;
import io.jboot.support.metric.reporter.graphite.JbootGraphiteReporter;
import io.jboot.support.metric.reporter.influxdb.InfluxdbReporter;
import io.jboot.support.metric.reporter.jmx.JMXReporter;
import io.jboot.support.metric.reporter.slf4j.JbootSlf4jReporter;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;

public class JbootMetricManager {
    private static final Log LOG = Log.getLog(JbootMetricManager.class);
    private static JbootMetricManager me;
    private MetricRegistry metricRegistry;
    private HealthCheckRegistry healthCheckRegistry;
    private JbootMetricConfig metricsConfig = Jboot.config(JbootMetricConfig.class);
    private boolean enable = false;

    public static JbootMetricManager me() {
        if (me == null) {
            me = new JbootMetricManager();
        }
        return me;
    }

    private JbootMetricManager() {
        if (!this.metricsConfig.isConfigOk()) {
            return;
        }
        this.metricRegistry = new MetricRegistry();
        this.healthCheckRegistry = new HealthCheckRegistry();
        List<JbootMetricReporter> reporters = this.getReporters();
        if (ArrayUtil.isNullOrEmpty(reporters)) {
            return;
        }
        for (JbootMetricReporter reporter : reporters) {
            try {
                reporter.report(this.metricRegistry);
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
        this.enable = true;
    }

    public boolean isEnable() {
        return this.enable;
    }

    private List<JbootMetricReporter> getReporters() {
        String[] repoterStrings;
        String repoterString = this.metricsConfig.getReporter();
        if (StrUtil.isBlank((String)repoterString)) {
            return null;
        }
        ArrayList<JbootMetricReporter> reporters = new ArrayList<JbootMetricReporter>();
        for (String repoterName : repoterStrings = repoterString.split(",")) {
            JbootMetricReporter reporter = this.getReporterByName(repoterName);
            if (reporter == null) continue;
            reporters.add(reporter);
        }
        return reporters;
    }

    private JbootMetricReporter getReporterByName(String repoterName) {
        JbootMetricReporter reporter = null;
        switch (repoterName) {
            case "jmx": {
                reporter = new JMXReporter();
                break;
            }
            case "influxdb": {
                reporter = new InfluxdbReporter();
                break;
            }
            case "graphite": {
                reporter = new JbootGraphiteReporter();
                break;
            }
            case "elasticsearch": {
                reporter = new ElasticsearchReporter();
                break;
            }
            case "ganglia": {
                reporter = new GangliaReporter();
                break;
            }
            case "console": {
                reporter = new JbootConsoleReporter();
                break;
            }
            case "csv": {
                reporter = new CSVReporter();
                break;
            }
            case "slf4j": {
                reporter = new JbootSlf4jReporter();
                break;
            }
            default: {
                reporter = JbootSpiLoader.load(JbootMetricReporter.class, repoterName);
            }
        }
        return reporter;
    }

    public MetricRegistry metric() {
        return this.metricRegistry;
    }

    public HealthCheckRegistry healthCheck() {
        return this.healthCheckRegistry;
    }
}

