/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric.reporter.graphite;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import io.jboot.Jboot;
import io.jboot.support.metric.JbootMetricReporter;
import io.jboot.support.metric.reporter.graphite.JbootMetricGraphiteReporterConfig;
import io.jboot.utils.StrUtil;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

public class JbootGraphiteReporter
implements JbootMetricReporter {
    @Override
    public void report(MetricRegistry metricRegistry) {
        JbootMetricGraphiteReporterConfig config = Jboot.config(JbootMetricGraphiteReporterConfig.class);
        if (StrUtil.isBlank((String)config.getHost())) {
            throw new NullPointerException("graphite reporter host must not be null, please config jboot.metrics.reporter.graphite.host in you properties.");
        }
        if (config.getPort() == null) {
            throw new NullPointerException("graphite reporter port must not be null, please config jboot.metrics.reporter.graphite.port in you properties.");
        }
        if (config.getPrefixedWith() == null) {
            throw new NullPointerException("graphite reporter prefixedWith must not be null, please config jboot.metrics.reporter.graphite.prefixedWith in you properties.");
        }
        Graphite graphite = new Graphite(new InetSocketAddress(config.getHost(), (int)config.getPort()));
        GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)metricRegistry).prefixedWith(config.getPrefixedWith()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
        reporter.start(1L, TimeUnit.MINUTES);
    }
}

