/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.redis;

import io.jboot.Jboot;
import io.jboot.support.redis.JbootRedis;

public class JbootRedisLock {
    long expireMsecs = 60000L;
    long timeoutMsecs = 0L;
    private String lockName;
    private boolean locked = false;
    private JbootRedis redis;

    public JbootRedisLock(String lockName) {
        if (lockName == null) {
            throw new NullPointerException("lockName must not null !");
        }
        this.lockName = lockName;
        this.redis = Jboot.getRedis();
    }

    public JbootRedisLock(String lockName, long timeoutMsecs) {
        if (lockName == null) {
            throw new NullPointerException("lockName must not null !");
        }
        this.lockName = lockName;
        this.timeoutMsecs = timeoutMsecs;
        this.redis = Jboot.getRedis();
    }

    public void runIfAcquired(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable must not null!");
        }
        try {
            if (this.acquire()) {
                runnable.run();
            }
        }
        finally {
            this.release();
        }
    }

    public boolean acquire() {
        long timeout = this.timeoutMsecs;
        do {
            Long oldValue;
            long expires;
            Long result;
            if ((result = this.redis.setnx(this.lockName, expires = System.currentTimeMillis() + this.expireMsecs + 1L)) != null && result == 1L) {
                this.locked = true;
                return true;
            }
            Long currentValue = (Long)this.redis.get(this.lockName);
            if (currentValue != null && currentValue < System.currentTimeMillis() && (oldValue = (Long)this.redis.getSet(this.lockName, expires)) != null && oldValue.equals(currentValue)) {
                this.locked = true;
                return true;
            }
            if (timeout <= 0L) continue;
            timeout -= 100L;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (timeout > 0L);
        return false;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void release() {
        if (!this.isLocked()) {
            return;
        }
        if (Jboot.getRedis().del((Object)this.lockName) > 0L) {
            this.locked = false;
        }
    }
}

