/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.redis;

import io.jboot.Jboot;
import io.jboot.exception.JbootException;
import io.jboot.support.redis.JbootRedis;
import io.jboot.support.redis.JbootRedisConfig;
import io.jboot.support.redis.jedis.JbootJedisClusterImpl;
import io.jboot.support.redis.jedis.JbootJedisImpl;

public class JbootRedisManager {
    private static JbootRedisManager manager = new JbootRedisManager();
    private JbootRedis redis;

    private JbootRedisManager() {
    }

    public static JbootRedisManager me() {
        return manager;
    }

    public JbootRedis getRedis() {
        if (this.redis == null) {
            JbootRedisConfig config = Jboot.config(JbootRedisConfig.class);
            this.redis = this.getRedis(config);
        }
        return this.redis;
    }

    public JbootRedis getRedis(JbootRedisConfig config) {
        if (config == null || !config.isConfigOk()) {
            return null;
        }
        switch (config.getType()) {
            case "jedis": {
                return this.getJedisClinet(config);
            }
            case "lettuce": {
                return this.getLettuceClient(config);
            }
            case "redisson": {
                return this.getRedissonClient(config);
            }
        }
        return null;
    }

    private JbootRedis getJedisClinet(JbootRedisConfig config) {
        if (config.isCluster()) {
            return new JbootJedisClusterImpl(config);
        }
        return new JbootJedisImpl(config);
    }

    private JbootRedis getLettuceClient(JbootRedisConfig config) {
        throw new JbootException("lettuce is not finished.");
    }

    private JbootRedis getRedissonClient(JbootRedisConfig config) {
        throw new JbootException("redisson is not finished.");
    }
}

