/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.seata;

import io.jboot.Jboot;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.seata.SeataConfig;
import io.jboot.support.seata.SeataGlobalTransactionManager;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import io.seata.rm.GlobalLockTemplate;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import io.seata.tm.api.TransactionalTemplate;
import javax.sql.DataSource;

public class JbootSeataManager {
    private static JbootSeataManager seataManager = new JbootSeataManager();
    private SeataConfig config = Jboot.config(SeataConfig.class);
    private boolean enable = false;
    private TransactionalTemplate transactionalTemplate;
    private GlobalLockTemplate<Object> globalLockTemplate;
    private SeataGlobalTransactionManager transactionManager;
    private Object handler;

    private JbootSeataManager() {
    }

    public static JbootSeataManager me() {
        return seataManager;
    }

    public void init() {
        if (!this.config.isEnable()) {
            return;
        }
        if (!this.config.isConfigOk()) {
            throw new JbootIllegalConfigException("please config applicationId and txServiceGroup for seata");
        }
        this.transactionManager = new SeataGlobalTransactionManager(this.config.getApplicationId(), this.config.getTxServiceGroup(), this.config.getMode());
        this.transactionManager.init();
        this.transactionalTemplate = new TransactionalTemplate();
        this.globalLockTemplate = new GlobalLockTemplate();
        this.enable = true;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void stop() {
        if (this.isEnable()) {
            this.transactionManager.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FailureHandler getFailureHandler() {
        if (this.handler == null) {
            JbootSeataManager jbootSeataManager = this;
            synchronized (jbootSeataManager) {
                if (this.handler == null) {
                    String failureHandlerClassOrSpiName = this.config.getFailureHandler();
                    if (StrUtil.isBlank((String)failureHandlerClassOrSpiName)) {
                        this.handler = new DefaultFailureHandlerImpl();
                    } else {
                        if (failureHandlerClassOrSpiName.contains(".")) {
                            this.handler = ClassUtil.newInstance(failureHandlerClassOrSpiName);
                        }
                        if (this.handler == null) {
                            this.handler = JbootSpiLoader.load(FailureHandler.class, failureHandlerClassOrSpiName);
                        }
                        if (this.handler == null) {
                            this.handler = new DefaultFailureHandlerImpl();
                        }
                    }
                }
            }
        }
        return (FailureHandler)this.handler;
    }

    public TransactionalTemplate getTransactionalTemplate() {
        return this.transactionalTemplate;
    }

    public void setTransactionalTemplate(TransactionalTemplate transactionalTemplate) {
        this.transactionalTemplate = transactionalTemplate;
    }

    public GlobalLockTemplate<Object> getGlobalLockTemplate() {
        return this.globalLockTemplate;
    }

    public void setGlobalLockTemplate(GlobalLockTemplate<Object> globalLockTemplate) {
        this.globalLockTemplate = globalLockTemplate;
    }

    public DataSource wrapDataSource(DataSource dataSource) {
        return this.config.isEnable() && this.config.isConfigOk() ? new DataSourceProxy(dataSource) : dataSource;
    }
}

