/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.sentinel;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.jfinal.aop.Invocation;
import io.jboot.support.sentinel.AbstractSentinelProccesser;

public class SentinelProcesser
extends AbstractSentinelProccesser {
    public void doProcess(Invocation inv) {
        SentinelResource annotation = inv.getMethod().getAnnotation(SentinelResource.class);
        if (annotation == null) {
            inv.invoke();
            return;
        }
        String resourceName = this.getResourceName(annotation.value(), inv.getMethod());
        EntryType entryType = annotation.entryType();
        int resourceType = annotation.resourceType();
        Entry entry = null;
        try {
            entry = SphU.entry((String)resourceName, (int)resourceType, (EntryType)entryType, (Object[])inv.getArgs());
            inv.invoke();
        }
        catch (BlockException ex) {
            try {
                inv.setReturnValue(this.handleBlockException(inv, annotation, ex));
            }
            catch (Throwable throwable) {
                if (inv.isActionInvocation()) {
                    inv.getController().renderText("Blocked by Sentinel " + ex.getRule());
                }
                throwable.printStackTrace();
            }
            return;
        }
        catch (Throwable ex) {
            Class[] exceptionsToIgnore = annotation.exceptionsToIgnore();
            if (exceptionsToIgnore.length > 0 && this.exceptionBelongsTo(ex, exceptionsToIgnore)) {
                throw ex;
            }
            if (this.exceptionBelongsTo(ex, annotation.exceptionsToTrace())) {
                this.traceException(ex);
                try {
                    inv.setReturnValue(this.handleFallback(inv, annotation, ex));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                return;
            }
            throw ex;
        }
        finally {
            if (entry != null) {
                entry.exit(1, inv.getArgs());
            }
        }
    }
}

