/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.env.WebEnvironment;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.servlet.ShiroFilter;
import org.apache.shiro.web.util.WebUtils;

public class JbootShiroFilter
extends ShiroFilter {
    private int contextPathLength = 0;

    public void init() throws Exception {
        WebEnvironment env = WebUtils.getRequiredWebEnvironment((ServletContext)this.getServletContext());
        if (env.getServletContext().getContextPath() != null) {
            this.contextPathLength = env.getServletContext().getContextPath().length();
        }
        this.setSecurityManager(env.getWebSecurityManager());
        FilterChainResolver resolver = env.getFilterChainResolver();
        if (resolver != null) {
            this.setFilterChainResolver(resolver);
        }
    }

    protected void doFilterInternal(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String target = request.getRequestURI();
        if (this.contextPathLength != 0) {
            target = target.substring(this.contextPathLength);
        }
        if (target.indexOf(46) != -1) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        super.doFilterInternal((ServletRequest)request, (ServletResponse)response, chain);
    }
}

