/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro.directives;

import com.jfinal.template.Env;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.Scope;
import io.jboot.support.shiro.directives.JbootShiroDirectiveBase;
import io.jboot.utils.ArrayUtil;
import io.jboot.web.directive.annotation.JFinalDirective;

@JFinalDirective(value="shiroHasAnyRoles")
public class ShiroHasAnyRolesDirective
extends JbootShiroDirectiveBase {
    @Override
    public void setExprList(ExprList exprList) {
        if (exprList.getExprArray().length == 0) {
            throw new IllegalArgumentException("#shiroHasAnyRoles argument must not be empty");
        }
        super.setExprList(exprList);
    }

    @Override
    public void onRender(Env env, Scope scope, Writer writer) {
        if (this.getSubject() != null && ArrayUtil.isNotEmpty(this.exprList.getExprArray())) {
            for (Expr expr : this.exprList.getExprArray()) {
                if (!this.getSubject().hasRole(expr.eval(scope).toString())) continue;
                this.renderBody(env, scope, writer);
                break;
            }
        }
    }

    public boolean hasEnd() {
        return true;
    }
}

