/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.swagger;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Maps;
import com.jfinal.ext.cors.EnableCORS;
import io.jboot.Jboot;
import io.jboot.support.swagger.JbootSwaggerConfig;
import io.jboot.support.swagger.JbootSwaggerManager;
import io.jboot.support.swagger.RefPropertySerializer;
import io.jboot.web.controller.JbootController;
import io.swagger.models.Swagger;
import io.swagger.models.properties.RefProperty;

public class JbootSwaggerController
extends JbootController {
    JbootSwaggerConfig config = Jboot.config(JbootSwaggerConfig.class);

    public void index() {
        String html;
        try {
            String viewPath = this.config.getPath().endsWith("/") ? this.config.getPath() : this.config.getPath() + "/";
            html = this.renderToString(viewPath + "index.html", Maps.newHashMap());
        }
        catch (Exception ex) {
            this.renderHtml("error\uff0cplease put  <a href=\"https://github.com/swagger-api/swagger-ui\" target=\"_blank\">swagger-ui</a> into your project path :  " + this.config.getPath() + " <br />or click <a href=\"" + this.config.getPath() + "/json\">here</a>  show swagger json.");
            return;
        }
        String basePath = this.getRequest().getRequestURL().toString();
        String jsonUrl = basePath + "json";
        html = html.replace("http://petstore.swagger.io/v2/swagger.json", jsonUrl);
        html = html.replace("https://petstore.swagger.io/v2/swagger.json", jsonUrl);
        html = html.replace("src=\"./", "src=\"" + basePath);
        html = html.replace("href=\"./", "href=\"" + basePath);
        this.renderHtml(html);
    }

    @EnableCORS
    public void json() {
        Swagger swagger = JbootSwaggerManager.me().getSwagger();
        if (swagger == null) {
            this.renderText("swagger config error.");
            return;
        }
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.put(RefProperty.class, (ObjectSerializer)new RefPropertySerializer());
        this.renderJson(JSON.toJSONString((Object)swagger, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]));
    }
}

