/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import io.jboot.app.config.JbootConfigManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class ClassScanner {
    private static final Set<Class> appClassesCache;
    public static final Set<String> scanJars;
    public static final Set<String> excludeJars;
    public static final Set<String> scanClasses;
    public static final Set<String> excludeClasses;
    private static String javaHome;

    public static void addScanJarPrefix(String prefix) {
        scanJars.add(prefix.trim());
    }

    public static void addUnscanJarPrefix(String prefix) {
        excludeJars.add(prefix.trim());
    }

    public static void addUnscanClassPrefix(String prefix) {
        excludeClasses.add(prefix.trim());
    }

    public static void addScanClassPrefix(String prefix) {
        scanClasses.add(prefix.trim());
    }

    public static <T> List<Class<T>> scanSubClass(Class<T> pclazz) {
        return ClassScanner.scanSubClass(pclazz, false);
    }

    public static <T> List<Class<T>> scanSubClass(Class<T> pclazz, boolean isInstantiable) {
        ClassScanner.initIfNecessary();
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        ClassScanner.findChildClasses(classes, pclazz, isInstantiable);
        return classes;
    }

    public static List<Class> scanClass() {
        return ClassScanner.scanClass(false);
    }

    public static List<Class> scanClass(boolean isInstantiable) {
        ClassScanner.initIfNecessary();
        if (!isInstantiable) {
            return new ArrayList<Class>(appClassesCache);
        }
        return appClassesCache.stream().filter(ClassScanner::isInstantiable).collect(Collectors.toList());
    }

    public static void clearAppClassesCache() {
        appClassesCache.clear();
    }

    private static boolean isInstantiable(Class clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static List<Class> scanClassByAnnotation(Class annotationClass, boolean isInstantiable) {
        ClassScanner.initIfNecessary();
        ArrayList<Class> list = new ArrayList<Class>();
        for (Class clazz : appClassesCache) {
            Object annotation = clazz.getAnnotation(annotationClass);
            if (annotation == null || isInstantiable && !ClassScanner.isInstantiable(clazz)) continue;
            list.add(clazz);
        }
        return list;
    }

    private static void initIfNecessary() {
        if (appClassesCache.isEmpty()) {
            ClassScanner.initAppClasses();
        }
    }

    private static <T> void findChildClasses(List<Class<T>> classes, Class<T> parent, boolean isInstantiable) {
        for (Class clazz : appClassesCache) {
            if (!parent.isAssignableFrom(clazz) || isInstantiable && !ClassScanner.isInstantiable(clazz)) continue;
            classes.add(clazz);
        }
    }

    private static void initAppClasses() {
        HashSet<String> jarPaths = new HashSet<String>();
        HashSet<String> classPaths = new HashSet<String>();
        ClassScanner.findClassPathsAndJarsByClassloader(jarPaths, classPaths, ClassScanner.class.getClassLoader());
        ClassScanner.findClassPathsAndJarsByClassPath(jarPaths, classPaths);
        String tomcatClassPath = null;
        for (String classPath : classPaths) {
            File tomcatApiJarFile = new File(classPath, "tomcat-api.jar");
            File tomcatJuliJarFile = new File(classPath, "tomcat-juli.jar");
            if (tomcatApiJarFile.exists() || tomcatJuliJarFile.exists()) {
                tomcatClassPath = tomcatApiJarFile.getParentFile().getParentFile().getAbsolutePath().replace('\\', '/');
                continue;
            }
            if (JbootConfigManager.me().isDevMode()) {
                System.out.println("ClassScanner scan classpath : " + classPath);
            }
            ClassScanner.addClassesFromClassPath(classPath);
        }
        for (String jarPath : jarPaths) {
            if (tomcatClassPath != null && jarPath.startsWith(tomcatClassPath) && !jarPath.contains("webapps") || !ClassScanner.isIncludeJar(jarPath)) continue;
            if (JbootConfigManager.me().isDevMode()) {
                System.out.println("ClassScanner scan jar : " + jarPath);
            }
            ClassScanner.addClassesFromJar(jarPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addClassesFromJar(String jarPath) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entryName = jarEntry.getName();
                if (jarEntry.isDirectory() || !entryName.endsWith(".class")) continue;
                String className = entryName.replace("/", ".").substring(0, entryName.length() - 6);
                ClassScanner.addClass(ClassScanner.classForName(className));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void addClassesFromClassPath(String classPath) {
        ArrayList<File> classFileList = new ArrayList<File>();
        ClassScanner.scanClassFile(classFileList, classPath);
        for (File file : classFileList) {
            int start = classPath.length();
            int end = file.toString().length() - ".class".length();
            String classFile = file.toString().substring(start + 1, end);
            String className = classFile.replace(File.separator, ".");
            ClassScanner.addClass(ClassScanner.classForName(className));
        }
    }

    private static void addClass(Class clazz) {
        if (clazz != null && ClassScanner.isNotExcludeClass(clazz.getName())) {
            appClassesCache.add(clazz);
        }
    }

    private static boolean isNotExcludeClass(String clazzName) {
        for (String prefix : scanClasses) {
            if (!clazzName.startsWith(prefix)) continue;
            return true;
        }
        for (String prefix : excludeClasses) {
            if (!clazzName.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    private static void findClassPathsAndJarsByClassloader(Set<String> jarPaths, Set<String> classPaths, ClassLoader classLoader) {
        try {
            URL[] urls = null;
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)classLoader;
                urls = ucl.getURLs();
            }
            if (urls != null) {
                for (URL url : urls) {
                    String path = url.getPath();
                    if ((path = URLDecoder.decode(path, "UTF-8")).startsWith("/") && path.indexOf(":") == 2) {
                        path = path.substring(1);
                    }
                    if (!path.toLowerCase().endsWith(".jar")) {
                        classPaths.add(new File(path).getCanonicalPath().replace('\\', '/'));
                        continue;
                    }
                    jarPaths.add(path.replace('\\', '/'));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ClassLoader parent = classLoader.getParent();
        if (parent != null) {
            ClassScanner.findClassPathsAndJarsByClassloader(jarPaths, classPaths, parent);
        }
    }

    private static void findClassPathsAndJarsByClassPath(Set<String> jarPaths, Set<String> classPaths) {
        String classPath = System.getProperty("java.class.path");
        if (classPath == null || classPath.trim().length() == 0) {
            return;
        }
        String[] classPathArray = classPath.split(File.pathSeparator);
        if (classPathArray == null || classPathArray.length == 0) {
            return;
        }
        for (String path : classPathArray) {
            if ((path = path.trim()).startsWith("./")) {
                path = path.substring(2);
            }
            if (path.startsWith("/") && path.indexOf(":") == 2) {
                path = path.substring(1);
            }
            if (!path.toLowerCase().endsWith(".jar") && !jarPaths.contains(path)) {
                try {
                    classPaths.add(new File(path).getCanonicalPath().replace('\\', '/'));
                }
                catch (IOException iOException) {}
                continue;
            }
            jarPaths.add(path.replace('\\', '/'));
        }
    }

    private static boolean isIncludeJar(String path) {
        String jarName = new File(path).getName().toLowerCase();
        for (String include : scanJars) {
            if (!jarName.startsWith(include)) continue;
            return true;
        }
        for (String exclude : excludeJars) {
            if (!jarName.startsWith(exclude)) continue;
            return false;
        }
        if (path.contains("/jre/lib")) {
            return false;
        }
        return ClassScanner.getJavaHome() == null || !path.startsWith(ClassScanner.getJavaHome());
    }

    private static Class classForName(String className) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return Class.forName(className, false, cl);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static void scanClassFile(List<File> fileList, String path) {
        File[] files = new File(path).listFiles();
        if (null == files || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ClassScanner.scanClassFile(fileList, file.getAbsolutePath());
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            fileList.add(file);
        }
    }

    private static String getJavaHome() {
        if (javaHome == null) {
            try {
                String javaHomeString = System.getProperty("java.home");
                if (javaHomeString != null && javaHomeString.trim().length() > 0) {
                    javaHome = new File(javaHomeString, "..").getCanonicalPath().replace('\\', '/');
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return javaHome;
    }

    static {
        String scanClassPrefix;
        String unScanClassPrefix;
        String unScanJarPrefix;
        appClassesCache = new HashSet<Class>();
        scanJars = new HashSet<String>();
        excludeJars = new HashSet<String>();
        scanClasses = new HashSet<String>();
        excludeClasses = new HashSet<String>();
        scanJars.add("jboot");
        excludeJars.add("jfinal-");
        excludeJars.add("cos-");
        excludeJars.add("cglib-");
        excludeJars.add("undertow-");
        excludeJars.add("xnio-");
        excludeJars.add("javax.");
        excludeJars.add("hikaricp-");
        excludeJars.add("druid-");
        excludeJars.add("mysql-");
        excludeJars.add("db2jcc-");
        excludeJars.add("db2jcc4-");
        excludeJars.add("ojdbc");
        excludeJars.add("junit-");
        excludeJars.add("org.junit");
        excludeJars.add("hamcrest-");
        excludeJars.add("jboss-");
        excludeJars.add("motan-");
        excludeJars.add("commons-pool");
        excludeJars.add("commons-beanutils");
        excludeJars.add("commons-codec");
        excludeJars.add("commons-collections");
        excludeJars.add("commons-configuration");
        excludeJars.add("commons-lang");
        excludeJars.add("commons-logging");
        excludeJars.add("commons-io");
        excludeJars.add("commons-httpclient");
        excludeJars.add("commons-fileupload");
        excludeJars.add("commons-validator");
        excludeJars.add("commons-email");
        excludeJars.add("commons-text");
        excludeJars.add("commons-cli");
        excludeJars.add("commons-math");
        excludeJars.add("commons-jxpath");
        excludeJars.add("commons-compress");
        excludeJars.add("audience-");
        excludeJars.add("hessian-");
        excludeJars.add("metrics-");
        excludeJars.add("javapoet-");
        excludeJars.add("netty-");
        excludeJars.add("consul-");
        excludeJars.add("gson-");
        excludeJars.add("zookeeper-");
        excludeJars.add("slf4j-");
        excludeJars.add("fastjson-");
        excludeJars.add("guava-");
        excludeJars.add("failureaccess-");
        excludeJars.add("listenablefuture-");
        excludeJars.add("jsr305-");
        excludeJars.add("checker-qual-");
        excludeJars.add("error_prone_annotations-");
        excludeJars.add("j2objc-");
        excludeJars.add("animal-sniffer-");
        excludeJars.add("cron4j-");
        excludeJars.add("jedis-");
        excludeJars.add("lettuce-");
        excludeJars.add("reactor-");
        excludeJars.add("fst-");
        excludeJars.add("kryo-");
        excludeJars.add("jackson-");
        excludeJars.add("javassist-");
        excludeJars.add("objenesis-");
        excludeJars.add("reflectasm-");
        excludeJars.add("asm-");
        excludeJars.add("minlog-");
        excludeJars.add("jsoup-");
        excludeJars.add("ons-client-");
        excludeJars.add("amqp-client-");
        excludeJars.add("ehcache-");
        excludeJars.add("sharding-");
        excludeJars.add("snakeyaml-");
        excludeJars.add("groovy-");
        excludeJars.add("profiler-");
        excludeJars.add("joda-time-");
        excludeJars.add("shiro-");
        excludeJars.add("dubbo-");
        excludeJars.add("curator-");
        excludeJars.add("resteasy-");
        excludeJars.add("reactive-");
        excludeJars.add("validation-");
        excludeJars.add("httpclient-");
        excludeJars.add("httpcore-");
        excludeJars.add("httpmime-");
        excludeJars.add("jcip-");
        excludeJars.add("jcl-");
        excludeJars.add("microprofile-");
        excludeJars.add("org.osgi");
        excludeJars.add("zkclient-");
        excludeJars.add("jjwt-");
        excludeJars.add("okhttp-");
        excludeJars.add("okio-");
        excludeJars.add("zbus-");
        excludeJars.add("swagger-");
        excludeJars.add("j2cache-");
        excludeJars.add("caffeine-");
        excludeJars.add("jline-");
        excludeJars.add("qpid-");
        excludeJars.add("geronimo-");
        excludeJars.add("activation-");
        excludeJars.add("org.abego");
        excludeJars.add("antlr-");
        excludeJars.add("antlr4-");
        excludeJars.add("st4-");
        excludeJars.add("icu4j-");
        excludeJars.add("idea_rt");
        excludeJars.add("mrjtoolkit");
        excludeJars.add("logback-");
        excludeJars.add("log4j-");
        excludeJars.add("log4j2-");
        excludeJars.add("aliyun-java-sdk-");
        excludeJars.add("aliyun-sdk-");
        excludeJars.add("archaius-");
        excludeJars.add("aopalliance-");
        excludeJars.add("hdrhistogram-");
        excludeJars.add("jdom-");
        excludeJars.add("rxjava-");
        excludeJars.add("jersey-");
        excludeJars.add("stax-");
        excludeJars.add("stax2-");
        excludeJars.add("jettison-");
        excludeJars.add("commonmark-");
        excludeJars.add("jaxb-");
        excludeJars.add("json-20");
        excludeJars.add("jcseg-");
        excludeJars.add("lucene-");
        excludeJars.add("elasticsearch-");
        excludeJars.add("jopt-");
        excludeJars.add("httpasyncclient-");
        excludeJars.add("jna-");
        excludeJars.add("lang-mustache-client-");
        excludeJars.add("parent-join-client-");
        excludeJars.add("rank-eval-client-");
        excludeJars.add("aggs-matrix-stats-client-");
        excludeJars.add("t-digest-");
        excludeJars.add("compiler-");
        excludeJars.add("hppc-");
        excludeJars.add("libthrift-");
        excludeJars.add("seata-");
        excludeJars.add("eureka-");
        excludeJars.add("netflix-");
        excludeJars.add("nacos-");
        excludeJars.add("apollo-");
        excludeJars.add("guice-");
        excludeJars.add("servlet-");
        excludeJars.add("debugger-agent.jar");
        excludeJars.add("xpp3_min-");
        excludeJars.add("latency");
        excludeJars.add("micrometer-");
        excludeJars.add("xstream-");
        excludeJars.add("jsr311-");
        excludeJars.add("servo-");
        excludeJars.add("compactmap-");
        excludeJars.add("dexx-");
        excludeJars.add("spotbugs-");
        excludeJars.add("xmlpull-");
        excludeJars.add("shardingsphere-");
        excludeJars.add("sentinel-");
        excludeJars.add("spring-");
        excludeJars.add("simpleclient-");
        excludeJars.add("breeze-");
        excludeJars.add("config-");
        excludeJars.add("encrypt-core-");
        excludeJars.add("lombok-");
        excludeJars.add("hutool-");
        excludeJars.add("jakarta.");
        excludeJars.add("protostuff-");
        excludeJars.add("poi-");
        excludeJars.add("easypoi-");
        excludeJars.add("ognl-");
        excludeJars.add("xmlbeans-");
        excludeJars.add("master-slave-core-");
        excludeJars.add("shadow-core-rewrite-");
        excludeJars.add("apiguardian-api-");
        excludeJars.add("opentest4j-");
        excludeJars.add("freemarker-");
        excludeClasses.add("com.jfinal.");
        excludeClasses.add("org.aopalliance.");
        excludeClasses.add("org.apache.");
        excludeClasses.add("org.nustaq.");
        excludeClasses.add("net.sf.");
        excludeClasses.add("org.slf4j.");
        excludeClasses.add("org.antlr.");
        excludeClasses.add("org.jboss.");
        excludeClasses.add("org.javassist.");
        excludeClasses.add("org.hamcrest.");
        excludeClasses.add("org.jsoup.");
        excludeClasses.add("org.objenesis.");
        excludeClasses.add("org.ow2.");
        excludeClasses.add("org.reactivest.");
        excludeClasses.add("org.yaml.");
        excludeClasses.add("org.checker");
        excludeClasses.add("org.codehaus");
        excludeClasses.add("ch.qos.");
        excludeClasses.add("com.alibaba.csp.");
        excludeClasses.add("com.alibaba.nacos.");
        excludeClasses.add("com.alibaba.druid.");
        excludeClasses.add("com.alibaba.fastjson.");
        excludeClasses.add("com.aliyun.open");
        excludeClasses.add("com.caucho");
        excludeClasses.add("com.codahale");
        excludeClasses.add("com.ctrip.framework.apollo");
        excludeClasses.add("com.ecwid.");
        excludeClasses.add("com.esotericsoftware.");
        excludeClasses.add("com.fasterxml.");
        excludeClasses.add("com.github.");
        excludeClasses.add("com.google.");
        excludeClasses.add("com.rabbitmq.");
        excludeClasses.add("com.squareup.");
        excludeClasses.add("com.typesafe.");
        excludeClasses.add("com.weibo.api.motan.");
        excludeClasses.add("com.zaxxer.");
        excludeClasses.add("com.mysql.");
        excludeClasses.add("org.gjt.");
        excludeClasses.add("io.dropwizard");
        excludeClasses.add("io.jsonwebtoken");
        excludeClasses.add("io.lettuce");
        excludeClasses.add("reactor.adapter");
        excludeClasses.add("io.prometheus");
        excludeClasses.add("io.seata.");
        excludeClasses.add("io.swagger.");
        excludeClasses.add("io.undertow.");
        excludeClasses.add("it.sauronsoftware");
        excludeClasses.add("javax.");
        excludeClasses.add("java.");
        excludeClasses.add("junit.");
        excludeClasses.add("jline.");
        excludeClasses.add("redis.");
        excludeClasses.add("lombok.");
        excludeClasses.add("net.oschina.j2cache");
        excludeClasses.add("cn.hutool.");
        excludeClasses.add("com.dyuproject.");
        excludeClasses.add("io.protostuff.");
        excludeClasses.add("io.jboot.core.");
        excludeClasses.add("io.jboot.web.");
        excludeClasses.add("io.jboot.objects.");
        excludeClasses.add("io.jboot.utils.");
        excludeClasses.add("io.jboot.codegen.");
        excludeClasses.add("io.jboot.wechat.");
        excludeClasses.add("io.jboot.components.");
        excludeClasses.add("io.jboot.support.");
        excludeClasses.add("io.jboot.exception.");
        excludeClasses.add("io.jboot.db.");
        excludeClasses.add("io.jboot.aop.");
        excludeClasses.add("io.jboot.app.");
        excludeClasses.add("io.jboot.service.");
        excludeClasses.add("io.jboot.Jboot");
        excludeClasses.add("freemarker.");
        scanClasses.add("io.jboot.support.shiro.directives");
        String scanJarPrefix = JbootConfigManager.me().getConfigValue("jboot.app.scanner.scanJarPrefix");
        if (scanJarPrefix != null) {
            String[] prefixes;
            for (String prefix : prefixes = scanJarPrefix.split(",")) {
                if (prefix == null || prefix.trim().length() <= 0) continue;
                ClassScanner.addScanJarPrefix(prefix.trim());
            }
        }
        if ((unScanJarPrefix = JbootConfigManager.me().getConfigValue("jboot.app.scanner.unScanJarPrefix")) != null) {
            String[] prefixes;
            for (String prefix : prefixes = unScanJarPrefix.split(",")) {
                if (prefix == null || prefix.trim().length() <= 0) continue;
                ClassScanner.addUnscanJarPrefix(prefix.trim());
            }
        }
        if ((unScanClassPrefix = JbootConfigManager.me().getConfigValue("jboot.app.scanner.unScanClassPrefix")) != null) {
            String[] prefixes;
            for (String prefix : prefixes = unScanClassPrefix.split(",")) {
                if (prefix == null || prefix.trim().length() <= 0) continue;
                ClassScanner.addUnscanClassPrefix(prefix.trim());
            }
        }
        if ((scanClassPrefix = JbootConfigManager.me().getConfigValue("jboot.app.scanner.scanClassPrefix")) != null) {
            String[] prefixes;
            for (String prefix : prefixes = scanClassPrefix.split(",")) {
                if (prefix == null || prefix.trim().length() <= 0) continue;
                ClassScanner.addScanClassPrefix(prefix.trim());
            }
        }
    }
}

