/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.aop.Aop;
import com.jfinal.log.Log;
import io.jboot.aop.annotation.StaticConstruct;
import io.jboot.exception.JbootException;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassUtil {
    public static Log log = Log.getLog(ClassUtil.class);
    private static final Map<Class, Object> singletons = new ConcurrentHashMap<Class, Object>();
    private static final String ENHANCER_BY = "$$EnhancerBy";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T singleton(Class<T> clazz) {
        Object object = singletons.get(clazz);
        if (object == null) {
            Class<T> clazz2 = clazz;
            synchronized (clazz2) {
                object = singletons.get(clazz);
                if (object == null) {
                    object = ClassUtil.newInstance(clazz);
                    if (object != null) {
                        singletons.put(clazz, object);
                    } else {
                        Log.getLog(clazz).error("cannot new newInstance!!!!");
                    }
                }
            }
        }
        return (T)object;
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ClassUtil.newInstance(clazz, true);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... paras) {
        return ClassUtil.newInstance(clazz, true, paras);
    }

    public static <T> T newInstance(Class<T> clazz, boolean createByAop) {
        if (createByAop) {
            return (T)Aop.get(clazz);
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("can not newInstance class:" + clazz + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz, boolean createByAop, Object ... paras) {
        try {
            Class[] classes = new Class[paras.length];
            for (int i = 0; i < paras.length; ++i) {
                Object data = paras[i];
                if (data == null) {
                    throw new IllegalArgumentException("paras must not null");
                }
                classes[i] = data.getClass();
            }
            Constructor<T> constructor = clazz.getDeclaredConstructor(classes);
            constructor.setAccessible(true);
            T ret = constructor.newInstance(paras);
            if (createByAop) {
                Aop.inject(ret);
            }
            return ret;
        }
        catch (Exception e) {
            log.error("can not newInstance class:" + clazz + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstanceByStaticConstruct(Class<T> clazz) {
        StaticConstruct staticConstruct = clazz.getAnnotation(StaticConstruct.class);
        if (staticConstruct == null) {
            return null;
        }
        return ClassUtil.newInstanceByStaticConstruct(clazz, staticConstruct);
    }

    public static <T> T newInstanceByStaticConstruct(Class<T> clazz, StaticConstruct staticConstruct) {
        Method method = ClassUtil.getStaticConstruct(staticConstruct.value(), clazz);
        if (method == null) {
            throw new JbootException("can not new instance by static constrauct for class : " + clazz);
        }
        try {
            return (T)method.invoke(null, null);
        }
        catch (Exception e) {
            log.error("can not invoke method:" + method.getName() + " in class : " + clazz + "\n" + e.toString(), (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static Method getStaticConstruct(String name, Class clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getReturnType() != clazz) continue;
            if (StrUtil.isBlank((String)name)) {
                return method;
            }
            if (!name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public static <T> T newInstance(String clazzName) {
        return ClassUtil.newInstance(clazzName, true);
    }

    public static <T> T newInstance(String clazzName, boolean createByAop) {
        return ClassUtil.newInstance(clazzName, createByAop, Thread.currentThread().getContextClassLoader());
    }

    public static <T> T newInstance(String clazzName, boolean createByAop, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(clazzName, false, classLoader);
            return (T)ClassUtil.newInstance(clazz, createByAop);
        }
        catch (Exception e) {
            log.error("can not newInstance class:" + clazzName + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static Class getUsefulClass(Class<?> clazz) {
        return clazz.getName().indexOf(ENHANCER_BY) == -1 ? clazz : clazz.getSuperclass();
    }

    public static Class getGenericClass(Class<?> clazz) {
        return ClassUtil.getGenericClass(ClassUtil.getUsefulClass(clazz).getGenericSuperclass());
    }

    public static Class[] getGenericClass(Method method) {
        Type[] type = method.getGenericParameterTypes();
        Class[] classes = new Class[type.length];
        for (int i = 0; i < type.length; ++i) {
            classes[i] = ClassUtil.getGenericClass(type[i]);
        }
        return classes;
    }

    public static Class getGenericClass(Field field) {
        return ClassUtil.getGenericClass(field.getType());
    }

    public static Class getGenericClass(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    public static String buildMethodString(Method method) {
        StringBuilder sb = new StringBuilder().append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("(");
        Class<?>[] params = method.getParameterTypes();
        int in = 0;
        for (Class<?> clazz : params) {
            sb.append(clazz.getName());
            if (++in >= params.length) continue;
            sb.append(",");
        }
        return sb.append(")").toString();
    }
}

