/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import io.jboot.utils.ObjectFunc;
import java.util.Collection;
import java.util.Objects;

public class ObjectUtil {
    public static <T> boolean isContainsObject(Collection<T> objects, T compareObject, ObjectFunc<T> ... compareAttrGetters) {
        if (objects == null || objects.isEmpty() || compareObject == null) {
            return false;
        }
        if (compareAttrGetters == null || compareAttrGetters.length == 0) {
            throw new IllegalArgumentException("compareAttrGetters must not be null");
        }
        for (T object : objects) {
            if (!ObjectUtil.isSameObject(object, compareObject, compareAttrGetters)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getContainsObject(Collection<T> objects, T compareObject, ObjectFunc<T> ... compareAttrGetters) {
        if (objects == null || objects.isEmpty() || compareObject == null) {
            return null;
        }
        if (compareAttrGetters == null || compareAttrGetters.length == 0) {
            throw new IllegalArgumentException("compareAttrGetters must not be null");
        }
        for (T object : objects) {
            if (!ObjectUtil.isSameObject(object, compareObject, compareAttrGetters)) continue;
            return object;
        }
        return null;
    }

    public static <T> boolean isSameObject(T object1, T object2, ObjectFunc<T> ... compareAttrGetters) {
        if (object1 == null || object2 == null) {
            return object1 == object2;
        }
        if (compareAttrGetters == null || compareAttrGetters.length == 0) {
            throw new IllegalArgumentException("compareAttrGetters must not be null");
        }
        for (ObjectFunc<T> getter : compareAttrGetters) {
            if (getter == null) {
                throw new IllegalArgumentException("compareAttrGetter must not be null");
            }
            if (Objects.equals(getter.get(object1), getter.get(object2))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean notSameObject(T object1, T object2, ObjectFunc<T> ... compareAttrGetters) {
        return !ObjectUtil.isSameObject(object1, object2, compareAttrGetters);
    }
}

