/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.core.Controller;
import io.jboot.utils.StrUtil;
import io.jboot.web.controller.JbootControllerContext;
import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    static String[] mobileAgents = new String[]{"iphone", "android", "phone", "mobile", "wap", "netfront", "java", "opera mobi", "opera mini", "ucweb", "windows ce", "symbian", "series", "webos", "sony", "blackberry", "dopod", "nokia", "samsung", "palmsource", "xda", "pieplus", "meizu", "midp", "cldc", "motorola", "foma", "docomo", "up.browser", "up.link", "blazer", "helio", "hosin", "huawei", "novarra", "coolpad", "webos", "techfaith", "palmsource", "alcatel", "amoi", "ktouch", "nexian", "ericsson", "philips", "sagem", "wellcom", "bunjalloo", "maui", "smartphone", "iemobile", "spice", "bird", "zte-", "longcos", "pantech", "gionee", "portalmmm", "jig browser", "hiptop", "benq", "haier", "^lct", "320x320", "240x320", "176x220", "w3c ", "acs-", "alav", "alca", "amoi", "audi", "avan", "benq", "bird", "blac", "blaz", "brew", "cell", "cldc", "cmd-", "dang", "doco", "eric", "hipt", "inno", "ipaq", "java", "jigs", "kddi", "keji", "leno", "lg-c", "lg-d", "lg-g", "lge-", "maui", "maxo", "midp", "mits", "mmef", "mobi", "mot-", "moto", "mwbp", "nec-", "newt", "noki", "oper", "palm", "pana", "pant", "phil", "play", "port", "prox", "qwap", "sage", "sams", "sany", "sch-", "sec-", "send", "seri", "sgh-", "shar", "sie-", "siem", "smal", "smar", "sony", "sph-", "symb", "t-mo", "teli", "tim-", "tsm-", "upg1", "upsi", "vk-v", "voda", "wap-", "wapa", "wapi", "wapp", "wapr", "webc", "winw", "winw", "xda", "xda-", "googlebot-mobile"};

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String header = request.getHeader("X-Requested-With");
        return "XMLHttpRequest".equalsIgnoreCase(header);
    }

    public static boolean isMultipartRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().indexOf("multipart") != -1;
    }

    public static boolean isMobileBrowser(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        if (StrUtil.isNotBlank(ua)) {
            ua = ua.toLowerCase();
            for (String mobileAgent : mobileAgents) {
                if (ua.indexOf(mobileAgent) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWechatBrowser(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        return StrUtil.isNotBlank(ua) && ua.toLowerCase().indexOf("micromessenger") > -1;
    }

    public static boolean isWechatPcBrowser(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        return StrUtil.isNotBlank(ua) && ua.toLowerCase().indexOf("windowswechat") > -1;
    }

    public static boolean isIEBrowser(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        if (StrUtil.isBlank((String)ua)) {
            return false;
        }
        if ((ua = ua.toLowerCase()).indexOf("msie") > -1) {
            return true;
        }
        return ua.indexOf("gecko") > -1 && ua.indexOf("rv:11") > -1;
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-requested-For");
        if (StrUtil.isBlank((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (StrUtil.isBlank((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StrUtil.isBlank((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StrUtil.isBlank((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StrUtil.isBlank((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StrUtil.isBlank((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.contains(",")) {
            String[] ips = ip.split(",");
            for (int index = 0; index < ips.length; ++index) {
                String strIp = ips[index];
                if ("unknown".equalsIgnoreCase(strIp)) continue;
                ip = strIp;
                break;
            }
        }
        return ip;
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }

    public static String getReferer(HttpServletRequest request) {
        return request.getHeader("Referer");
    }

    public static String getBaseUrl(HttpServletRequest request) {
        int port = request.getServerPort();
        StringBuilder defaultDomain = new StringBuilder(request.getScheme());
        defaultDomain.append("://").append(request.getServerName()).append(port == 80 ? "" : ":" + port).append(request.getContextPath());
        return defaultDomain.toString();
    }

    public static String getBaseUrl() {
        Controller controller = JbootControllerContext.get();
        return controller == null ? null : RequestUtil.getBaseUrl(controller.getRequest());
    }

    public static String getCurrentUrl() {
        Controller controller = JbootControllerContext.get();
        return controller == null ? null : RequestUtil.getCurrentUrl(controller.getRequest());
    }

    public static String getCurrentUrl(HttpServletRequest request) {
        String queryString = request.getQueryString();
        String url = RequestUtil.getBaseUrl(request) + request.getRequestURI();
        if (StrUtil.isNotBlank(queryString)) {
            url = url.concat("?").concat(queryString);
        }
        return url;
    }

    public static String getCurrentEncodeUrl() {
        Controller controller = JbootControllerContext.get();
        return controller == null ? null : RequestUtil.getCurrentEncodeUrl(controller.getRequest());
    }

    public static String getCurrentEncodeUrl(HttpServletRequest request) {
        return StrUtil.urlEncode(RequestUtil.getCurrentUrl(request));
    }
}

