/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.core.JFinal;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.Model;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class StrUtil
extends StrKit {
    private static final Log log = Log.getLog(StrUtil.class);
    public static final String EMPTY = "";
    public static final String SPACE = " ";
    private static final String[] htmlChars = new String[]{"&", "<", ">", "'", "\""};
    private static final String[] escapeChars = new String[]{"&amp;", "&lt;", "&gt;", "&#39;", "&quot;"};

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, JFinal.me().getConstants().getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.error("urlDecode is error", (Throwable)e);
            return string;
        }
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, JFinal.me().getConstants().getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.error("urlEncode is error", (Throwable)e);
            return string;
        }
    }

    public static String urlRedirect(String redirect) {
        try {
            redirect = new String(redirect.getBytes(JFinal.me().getConstants().getEncoding()), "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            log.error("urlRedirect is error", (Throwable)e);
        }
        return redirect;
    }

    public static boolean areNotEmpty(String ... strs) {
        if (strs == null || strs.length == 0) {
            return false;
        }
        for (String string : strs) {
            if (string != null && !EMPTY.equals(string)) continue;
            return false;
        }
        return true;
    }

    public static String requireNonBlank(String str) {
        if (StrUtil.isBlank((String)str)) {
            throw new NullPointerException();
        }
        return str;
    }

    public static String requireNonBlank(String str, String message) {
        if (StrUtil.isBlank((String)str)) {
            throw new NullPointerException(message);
        }
        return str;
    }

    public static String obtainDefaultIfBlank(String str, String defaultValue) {
        return StrUtil.isBlank((String)str) ? defaultValue : str;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !str.equals(EMPTY);
    }

    public static boolean isNotBlank(Object str) {
        return str == null ? false : StrUtil.notBlank((String)str.toString());
    }

    public static boolean isNullOrBlank(String str) {
        return StrUtil.isBlank((String)str);
    }

    public static boolean match(String string, String regex) {
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static boolean isNumeric(String str) {
        if (StrUtil.isBlank((String)str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            char chr = str.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isDecimal(String str) {
        if (StrUtil.isBlank((String)str)) {
            return false;
        }
        boolean hasDot = false;
        int i = str.length();
        while (--i >= 0) {
            char chr = str.charAt(i);
            if ((chr < '0' || chr > '9') && chr != '.') {
                return false;
            }
            if (chr != '.') continue;
            if (hasDot) {
                return false;
            }
            hasDot = true;
        }
        return true;
    }

    public static boolean isEmail(String email) {
        return StrUtil.isBlank((String)email) ? false : Pattern.matches("\\w+@(\\w+.)+[a-z]{2,3}", email);
    }

    public static boolean isMobileNumber(String mobileNumber) {
        return StrUtil.isBlank((String)mobileNumber) ? false : Pattern.matches("^(1[3,4,5,6,7,8,9])\\d{9}$", mobileNumber);
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replace("-", EMPTY);
    }

    public static Set<String> splitToSetByComma(String src) {
        return StrUtil.splitToSet(src, ",");
    }

    public static Set<String> splitToSet(String src, String regex) {
        if (src == null) {
            return null;
        }
        String[] strings = src.split(regex);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String s : strings) {
            if (StrUtil.isBlank((String)s)) continue;
            set.add(s.trim());
        }
        return set;
    }

    public static String escapeHtml(String content) {
        return StrUtil.isBlank((String)content) ? content : StringUtils.replaceEach((String)StrUtil.unEscapeHtml(content), (String[])htmlChars, (String[])escapeChars);
    }

    public static String unEscapeHtml(String content) {
        return StrUtil.isBlank((String)content) ? content : StringUtils.replaceEach((String)content, (String[])escapeChars, (String[])htmlChars);
    }

    public static Model escapeModel(Model model, String ... ignoreAttrs) {
        String[] attrNames;
        for (String attr : attrNames = model._getAttrNames()) {
            Object value;
            if (ArrayUtils.contains((Object[])ignoreAttrs, (Object)attr) || (value = model.get(attr)) == null || !(value instanceof String)) continue;
            model.set(attr, (Object)StrUtil.escapeHtml(value.toString()));
        }
        return model;
    }

    public static Map escapeMap(Map map, Object ... ignoreKeys) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        Set keys = map.keySet();
        for (Object key : keys) {
            Object value;
            if (ArrayUtils.contains((Object[])ignoreKeys, key) || (value = map.get(key)) == null || !(value instanceof String)) continue;
            map.put(key, StrUtil.escapeHtml(value.toString()));
        }
        return map;
    }

    public static String join(String[] array, String split) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(split);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String join(Collection<String> coll, String split) {
        if (coll == null || coll.isEmpty()) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String s : coll) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(split);
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

