/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web;

import com.alibaba.fastjson.JSON;
import com.jfinal.json.JFinalJson;
import com.jfinal.json.JFinalJsonKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.CPI;
import com.jfinal.plugin.activerecord.Model;
import io.jboot.Jboot;
import io.jboot.utils.StrUtil;
import io.jboot.web.JbootWebConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JbootJson
extends JFinalJson {
    protected boolean isCamelCaseJsonStyleEnable = Jboot.config(JbootWebConfig.class).isCamelCaseJsonStyleEnable();
    protected boolean camelCaseToLowerCaseAnyway = Jboot.config(JbootWebConfig.class).isCamelCaseToLowerCaseAnyway();
    protected String jsonTimestampPattern = Jboot.config(JbootWebConfig.class).getJsonTimestampPattern();
    protected Map<Class, MethodsAndFieldsWrapper> methodAndFieldsCache = new HashMap<Class, MethodsAndFieldsWrapper>();
    protected JFinalJsonKit.ToJson<Model> jbootModelToJson = (model, depth, ret) -> {
        if (JFinalJsonKit.checkDepth((int)depth--, (JFinalJsonKit.JsonResult)ret)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.fillMapToMap(CPI.getAttrs((Model)model), map);
        this.fillBeanGetterValueToMap(model, map);
        this.optimizeMapAttrs(map);
        JFinalJsonKit.mapToJson(map, (int)depth, (JFinalJsonKit.JsonResult)ret);
    };

    public JbootJson() {
        JbootJson.setSkipNullValueField((boolean)true);
        if (this.isCamelCaseJsonStyleEnable) {
            JbootJson.setModelAndRecordFieldNameConverter(fieldName -> StrKit.toCamelCase((String)fieldName, (boolean)this.camelCaseToLowerCaseAnyway));
        }
        JbootJson.setToJsonFactory(o -> {
            if (o instanceof Model) {
                return this.jbootModelToJson;
            }
            return null;
        });
        if (StrUtil.isNotBlank(this.jsonTimestampPattern)) {
            this.setTimestampPattern(this.jsonTimestampPattern);
        }
    }

    protected void fillMapToMap(Map<String, Object> fillMap, Map<String, Object> toMap) {
        if (fillMap != null && !fillMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : fillMap.entrySet()) {
                String fieldName = entry.getKey();
                if (this.isCamelCaseJsonStyleEnable) {
                    fieldName = StrKit.toCamelCase((String)fieldName, (boolean)this.camelCaseToLowerCaseAnyway);
                }
                toMap.put(fieldName, entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillBeanGetterValueToMap(Object bean, Map toMap) {
        MethodsAndFieldsWrapper wrapper = this.methodAndFieldsCache.get(bean.getClass());
        if (wrapper == null) {
            JbootJson jbootJson = this;
            synchronized (jbootJson) {
                wrapper = wrapper == null ? new MethodsAndFieldsWrapper(bean.getClass()) : this.methodAndFieldsCache.get(bean.getClass());
            }
        }
        if (wrapper.fields.size() > 0) {
            int index = 0;
            for (String field : wrapper.fields) {
                try {
                    Object value = ((Method)wrapper.methods.get(index++)).invoke(bean, new Object[0]);
                    toMap.put(field, value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void optimizeMapAttrs(Map<String, Object> map) {
    }

    public <T> T parse(String jsonString, Class<T> type) {
        return (T)JSON.parseObject((String)jsonString, type);
    }

    public static class MethodsAndFieldsWrapper {
        private List<String> fields = new ArrayList<String>();
        private List<Method> methods = new ArrayList<Method>();

        public MethodsAndFieldsWrapper(Class reflectiveClass) {
            Method[] methodArray;
            for (Method m : methodArray = reflectiveClass.getMethods()) {
                if (m.getParameterCount() != 0 || m.getReturnType() == Void.TYPE || !Modifier.isPublic(m.getModifiers())) continue;
                String methodName = m.getName();
                int indexOfGet = methodName.indexOf("get");
                if (indexOfGet == 0 && methodName.length() > 3) {
                    String attrName = methodName.substring(3);
                    if (attrName.equals("Class")) continue;
                    this.fields.add(StrKit.firstCharToLowerCase((String)attrName));
                    this.methods.add(m);
                    continue;
                }
                int indexOfIs = methodName.indexOf("is");
                if (indexOfIs != 0 || methodName.length() <= 2) continue;
                String attrName = methodName.substring(2);
                this.fields.add(StrKit.firstCharToLowerCase((String)attrName));
                this.methods.add(m);
            }
        }
    }
}

