/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.core.ActionException;
import com.jfinal.core.Controller;
import com.jfinal.core.NotAction;
import com.jfinal.kit.JsonKit;
import com.jfinal.kit.StrKit;
import com.jfinal.render.RenderManager;
import io.jboot.support.jwt.JwtManager;
import io.jboot.utils.RequestUtil;
import io.jboot.utils.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class JbootController
extends Controller {
    private HashMap<String, Object> jwtMap;

    @NotAction
    public boolean isMobileBrowser() {
        return RequestUtil.isMobileBrowser(this.getRequest());
    }

    @NotAction
    public boolean isWechatBrowser() {
        return RequestUtil.isWechatBrowser(this.getRequest());
    }

    @NotAction
    public boolean isIEBrowser() {
        return RequestUtil.isIEBrowser(this.getRequest());
    }

    @NotAction
    public boolean isAjaxRequest() {
        return RequestUtil.isAjaxRequest(this.getRequest());
    }

    @NotAction
    public boolean isMultipartRequest() {
        return RequestUtil.isMultipartRequest(this.getRequest());
    }

    @NotAction
    public String getIPAddress() {
        return RequestUtil.getIpAddress(this.getRequest());
    }

    @NotAction
    public String getReferer() {
        return RequestUtil.getReferer(this.getRequest());
    }

    @NotAction
    public String getUserAgent() {
        return RequestUtil.getUserAgent(this.getRequest());
    }

    @NotAction
    public Controller setJwtAttr(String name, Object value) {
        if (this.jwtMap == null) {
            this.jwtMap = new HashMap();
        }
        this.jwtMap.put(name, value);
        return this;
    }

    @NotAction
    public Controller setJwtMap(Map map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        if (this.jwtMap == null) {
            this.jwtMap = new HashMap();
        }
        this.jwtMap.putAll(map);
        return this;
    }

    @NotAction
    public <T> T getJwtAttr(String name) {
        return (T)(this.jwtMap == null ? null : this.jwtMap.get(name));
    }

    @NotAction
    public HashMap<String, Object> getJwtAttrs() {
        return this.jwtMap;
    }

    @NotAction
    public <T> T getJwtPara(String name) {
        return JwtManager.me().getPara(name);
    }

    @NotAction
    public Map getJwtParas() {
        return JwtManager.me().getParas();
    }

    @NotAction
    public String createJwtToken() {
        if (this.jwtMap == null) {
            throw new NullPointerException("jwt attrs is null");
        }
        return JwtManager.me().createJwtToken(this.jwtMap);
    }

    @NotAction
    public String getBaseUrl() {
        return RequestUtil.getBaseUrl(this.getRequest());
    }

    @NotAction
    public String getCurrentUrl() {
        return RequestUtil.getCurrentUrl(this.getRequest());
    }

    @NotAction
    public <T> T getRawObject(Class<T> tClass) {
        return (T)(StrUtil.isBlank((String)this.getRawData()) ? null : JsonKit.parse((String)this.getRawData(), tClass));
    }

    @NotAction
    public JSONObject getRawObject() {
        return StrUtil.isBlank((String)this.getRawData()) ? null : JSON.parseObject((String)this.getRawData());
    }

    @NotAction
    public String getPara(String name) {
        String value = super.getPara(name);
        return "".equals(value) ? null : value;
    }

    @NotAction
    public Map<String, String> getParas() {
        HashMap<String, String> map = null;
        Enumeration names = this.getParaNames();
        if (names != null) {
            map = new HashMap<String, String>();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                map.put(name, this.getPara(name));
            }
        }
        return map;
    }

    @NotAction
    public String getTrimPara(String name) {
        String value = super.getPara(name);
        value = value == null ? null : value.trim();
        return "".equals(value) ? null : value;
    }

    @NotAction
    public String getTrimPara(int index) {
        String value = super.getPara(index);
        value = value == null ? null : value.trim();
        return "".equals(value) ? null : value;
    }

    @NotAction
    public String getEscapePara(String name) {
        String value = this.getTrimPara(name);
        if (value == null || "".equals(value)) {
            return null;
        }
        return StrUtil.escapeHtml(value);
    }

    @NotAction
    public String getEscapePara(String name, String defaultValue) {
        String value = this.getTrimPara(name);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return StrUtil.escapeHtml(value);
    }

    private BigInteger toBigInteger(String value, BigInteger defaultValue) {
        try {
            if (StrKit.isBlank((String)value)) {
                return defaultValue;
            }
            if ((value = value.trim()).startsWith("N") || value.startsWith("n")) {
                return BigInteger.ZERO.subtract(new BigInteger(value));
            }
            return new BigInteger(value);
        }
        catch (Exception e) {
            throw new ActionException(400, RenderManager.me().getRenderFactory().getErrorRender(400), "Can not parse the parameter \"" + value + "\" to BigInteger value.");
        }
    }

    @NotAction
    public BigInteger getParaToBigInteger(String name) {
        return this.toBigInteger(this.getTrimPara(name), null);
    }

    @NotAction
    public BigInteger getParaToBigInteger(String name, BigInteger defaultValue) {
        return this.toBigInteger(this.getTrimPara(name), defaultValue);
    }

    @NotAction
    public BigInteger getBigInteger(String name) {
        return this.toBigInteger(this.getTrimPara(name), null);
    }

    @NotAction
    public BigInteger getBigInteger(String name, BigInteger defaultValue) {
        return this.toBigInteger(this.getTrimPara(name), defaultValue);
    }

    private BigDecimal toBigDecimal(String value, BigDecimal defaultValue) {
        try {
            if (StrKit.isBlank((String)value)) {
                return defaultValue;
            }
            if ((value = value.trim()).startsWith("N") || value.startsWith("n")) {
                return BigDecimal.ZERO.subtract(new BigDecimal(value));
            }
            return new BigDecimal(value);
        }
        catch (Exception e) {
            throw new ActionException(400, RenderManager.me().getRenderFactory().getErrorRender(400), "Can not parse the parameter \"" + value + "\" to BigDecimal value.");
        }
    }

    @NotAction
    public BigDecimal getParaToBigDecimal(String name) {
        return this.toBigDecimal(this.getTrimPara(name), null);
    }

    @NotAction
    public BigDecimal getParaToBigDecimal(String name, BigDecimal defaultValue) {
        return this.toBigDecimal(this.getTrimPara(name), defaultValue);
    }

    @NotAction
    public BigDecimal getBigDecimal(String name) {
        return this.toBigDecimal(this.getTrimPara(name), null);
    }

    @NotAction
    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        return this.toBigDecimal(this.getTrimPara(name), defaultValue);
    }
}

