/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.directive.base;

import com.jfinal.aop.Aop;
import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.Scope;
import io.jboot.utils.StrUtil;
import java.io.IOException;
import java.math.BigInteger;

public abstract class JbootDirectiveBase
extends Directive {
    public JbootDirectiveBase() {
        Aop.inject((Object)((Object)this));
    }

    public void setExprList(ExprList exprList) {
        super.setExprList(exprList);
    }

    public void exec(Env env, Scope scope, Writer writer) {
        scope = new Scope(scope);
        scope.getCtrl().setLocalAssignment();
        this.exprList.eval(scope);
        this.onRender(env, scope, writer);
    }

    public abstract void onRender(Env var1, Scope var2, Writer var3);

    public void renderBody(Env env, Scope scope, Writer writer) {
        this.stat.exec(env, scope, writer);
    }

    public void renderText(Writer writer, String text) {
        try {
            writer.write(text);
        }
        catch (IOException e) {
            throw new TemplateException(e.getMessage(), this.location, (Throwable)e);
        }
    }

    public <T> T getPara(String key, Scope scope) {
        return this.getPara(key, scope, null);
    }

    public <T> T getPara(String key, Scope scope, T defaultValue) {
        Object data = scope.getLocal((Object)key);
        return (T)(data == null ? defaultValue : data);
    }

    public <T> T getPara(int index, Scope scope) {
        return this.getPara(index, scope, null);
    }

    public <T> T getPara(int index, Scope scope, T defaultValue) {
        if (index < 0 || index >= this.exprList.length()) {
            return defaultValue;
        }
        Object data = this.exprList.getExpr(index).eval(scope);
        return (T)(data == null ? defaultValue : data);
    }

    public Integer getParaToInt(String key, Scope scope) {
        Object object = this.getPara(key, scope, null);
        if (object == null || object instanceof Integer) {
            return (Integer)object;
        }
        String objStr = object.toString();
        return StrUtil.isBlank((String)objStr) ? null : Integer.valueOf(objStr);
    }

    public Integer getParaToInt(String key, Scope scope, Integer defaultValue) {
        Integer v = this.getParaToInt(key, scope);
        return v == null ? defaultValue : v;
    }

    public Integer getParaToInt(int index, Scope scope) {
        Object object = this.getPara(index, scope, null);
        if (object == null || object instanceof Integer) {
            return (Integer)object;
        }
        String objStr = object.toString();
        return StrUtil.isBlank((String)objStr) ? null : Integer.valueOf(objStr);
    }

    public Integer getParaToInt(int index, Scope scope, Integer defaultValue) {
        Integer v = this.getParaToInt(index, scope);
        return v == null ? defaultValue : v;
    }

    public Long getParaToLong(String key, Scope scope) {
        Object object = this.getPara(key, scope, null);
        if (object == null || object instanceof Long) {
            return (Long)object;
        }
        String objStr = object.toString();
        return StrUtil.isBlank((String)objStr) ? null : Long.valueOf(objStr);
    }

    public Long getParaToLong(String key, Scope scope, Long defaultValue) {
        Long v = this.getParaToLong(key, scope);
        return v == null ? defaultValue : v;
    }

    public Long getParaToLong(int index, Scope scope) {
        Object object = this.getPara(index, scope, null);
        if (object == null || object instanceof Long) {
            return (Long)object;
        }
        String objStr = object.toString();
        return StrUtil.isBlank((String)objStr) ? null : Long.valueOf(objStr);
    }

    public Long getParaToLong(int index, Scope scope, Long defaultValue) {
        Long v = this.getParaToLong(index, scope);
        return v == null ? defaultValue : v;
    }

    public Boolean getParaToBool(String key, Scope scope) {
        Object object = this.getPara(key, scope, null);
        if (object == null || object instanceof Boolean) {
            return (Boolean)object;
        }
        String objStr = object.toString();
        return StrUtil.isBlank((String)objStr) ? null : Boolean.valueOf(objStr);
    }

    public Boolean getParaToBool(String key, Scope scope, Boolean defaultValue) {
        Boolean v = this.getParaToBool(key, scope);
        return v == null ? defaultValue : v;
    }

    public Boolean getParaToBool(int index, Scope scope) {
        Object object = this.getPara(index, scope, null);
        if (object == null || object instanceof Boolean) {
            return (Boolean)object;
        }
        String objStr = object.toString();
        return StrUtil.isBlank((String)objStr) ? null : Boolean.valueOf(objStr);
    }

    public Boolean getParaToBool(int index, Scope scope, Boolean defaultValue) {
        Boolean v = this.getParaToBool(index, scope);
        return v == null ? defaultValue : v;
    }

    public BigInteger getParaToBigInteger(String key, Scope scope) {
        Object object = this.getPara(key, scope, null);
        if (object == null || object instanceof BigInteger) {
            return (BigInteger)object;
        }
        String objStr = object.toString();
        return StrUtil.isBlank((String)objStr) ? null : new BigInteger(objStr);
    }

    public BigInteger getParaToBigInteger(String key, Scope scope, BigInteger defaultValue) {
        BigInteger v = this.getParaToBigInteger(key, scope);
        return v == null ? defaultValue : v;
    }

    public BigInteger getParaToBigInteger(int index, Scope scope) {
        Object object = this.getPara(index, scope, null);
        if (object == null || object instanceof BigInteger) {
            return (BigInteger)object;
        }
        String objStr = object.toString();
        return StrUtil.isBlank((String)objStr) ? null : new BigInteger(objStr);
    }

    public BigInteger getParaToBigInteger(int index, Scope scope, BigInteger defaultValue) {
        BigInteger v = this.getParaToBigInteger(index, scope);
        return v == null ? defaultValue : v;
    }
}

