/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.fixedinterceptor;

import com.jfinal.aop.Aop;
import io.jboot.components.limiter.LimiterInterceptor;
import io.jboot.support.jwt.JwtInterceptor;
import io.jboot.support.metric.JbootMetricInterceptor;
import io.jboot.support.seata.interceptor.SeataGlobalTransactionalInterceptor;
import io.jboot.support.sentinel.SentinelInterceptor;
import io.jboot.support.shiro.JbootShiroInterceptor;
import io.jboot.web.cors.CORSInterceptor;
import io.jboot.web.fixedinterceptor.FixedInterceptor;
import io.jboot.web.fixedinterceptor.FixedInterceptorWapper;
import io.jboot.web.validate.ParaValidateInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class FixedInterceptors {
    private static final FixedInterceptors me = new FixedInterceptors();
    private FixedInterceptorWapper[] defaultInters = new FixedInterceptorWapper[]{new FixedInterceptorWapper(new SentinelInterceptor(), 9), new FixedInterceptorWapper(new LimiterInterceptor(), 10), new FixedInterceptorWapper(new CORSInterceptor(), 20), new FixedInterceptorWapper(new ParaValidateInterceptor(), 30), new FixedInterceptorWapper(new JwtInterceptor(), 40), new FixedInterceptorWapper(new JbootShiroInterceptor(), 50), new FixedInterceptorWapper(new JbootMetricInterceptor(), 60), new FixedInterceptorWapper(new SeataGlobalTransactionalInterceptor(), 80)};
    private List<FixedInterceptorWapper> userInters = new ArrayList<FixedInterceptorWapper>();
    private FixedInterceptor[] allInters = null;
    private List<FixedInterceptorWapper> inters;

    public static FixedInterceptors me() {
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FixedInterceptor[] all() {
        if (this.allInters == null) {
            FixedInterceptors fixedInterceptors = this;
            synchronized (fixedInterceptors) {
                if (this.allInters == null) {
                    this.initInters();
                }
            }
        }
        return this.allInters;
    }

    private void initInters() {
        FixedInterceptor[] interceptors = new FixedInterceptor[this.defaultInters.length + this.userInters.size()];
        this.inters = new ArrayList<FixedInterceptorWapper>();
        this.inters.addAll(Arrays.asList(this.defaultInters));
        this.inters.addAll(this.userInters);
        this.inters.sort(Comparator.comparingInt(FixedInterceptorWapper::getOrderNo));
        int i = 0;
        for (FixedInterceptorWapper interceptor : this.inters) {
            interceptors[i++] = interceptor.getFixedInterceptor();
        }
        this.allInters = interceptors;
    }

    public void add(FixedInterceptor interceptor) {
        Aop.inject((Object)interceptor);
        this.userInters.add(new FixedInterceptorWapper(interceptor));
    }

    public void add(FixedInterceptor interceptor, int orderNo) {
        if (orderNo < 0) {
            orderNo = 0;
        }
        Aop.inject((Object)interceptor);
        this.userInters.add(new FixedInterceptorWapper(interceptor, orderNo));
    }

    public List<FixedInterceptorWapper> list() {
        return this.inters;
    }
}

