/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.handler;

import com.jfinal.aop.Aop;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Action;
import com.jfinal.core.ActionException;
import com.jfinal.core.ActionHandler;
import com.jfinal.core.ActionReporter;
import com.jfinal.core.CPI;
import com.jfinal.core.Controller;
import com.jfinal.core.ForwardActionRender;
import com.jfinal.log.Log;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import io.jboot.utils.ClassUtil;
import io.jboot.web.controller.JbootControllerContext;
import io.jboot.web.fixedinterceptor.FixedInvocation;
import io.jboot.web.render.JbootRenderFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JbootActionHandler
extends ActionHandler {
    private static final Log log = Log.getLog(JbootActionHandler.class);

    public Action getAction(String target, String[] urlPara, HttpServletRequest request) {
        return this.getAction(target, urlPara);
    }

    protected Action getAction(String target, String[] urlPara) {
        return super.getAction(target, urlPara);
    }

    public Invocation getInvocation(Action action, Controller controller) {
        return new Invocation(action, controller);
    }

    public void setResponse(HttpServletResponse response, Action action) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        String qs;
        if (target.indexOf(46) != -1) {
            return;
        }
        isHandled[0] = true;
        String[] urlPara = new String[]{null};
        Action action = this.getAction(target, urlPara, request);
        if (action == null) {
            if (log.isWarnEnabled()) {
                String qs2 = request.getQueryString();
                log.warn("404 Action Not Found: " + (qs2 == null ? target : target + "?" + qs2));
            }
            renderManager.getRenderFactory().getErrorRender(404).setContext(request, response).render();
            return;
        }
        Controller controller = null;
        try {
            controller = this.controllerFactory.getController(action.getControllerClass());
            if (this.injectDependency) {
                Aop.inject((Object)controller);
            }
            JbootControllerContext.hold(controller);
            CPI._init_((Controller)controller, (Action)action, (HttpServletRequest)request, (HttpServletResponse)response, (String)urlPara[0]);
            Invocation invocation = this.getInvocation(action, controller);
            if (this.devMode) {
                if (ActionReporter.isReportAfterInvocation((HttpServletRequest)request)) {
                    this.invokeInvocation(invocation);
                    ActionReporter.report((String)target, (Controller)controller, (Action)action);
                } else {
                    ActionReporter.report((String)target, (Controller)controller, (Action)action);
                    this.invokeInvocation(invocation);
                }
            } else {
                this.invokeInvocation(invocation);
            }
            Render render = controller.getRender();
            if (render instanceof ForwardActionRender) {
                String actionUrl = ((ForwardActionRender)render).getActionUrl();
                if (target.equals(actionUrl)) {
                    throw new RuntimeException("The forward action url is the same as before.");
                }
                this.handle(actionUrl, request, response, isHandled);
                return;
            }
            if (render == null && Void.TYPE != action.getMethod().getReturnType() && renderManager.getRenderFactory() instanceof JbootRenderFactory) {
                JbootRenderFactory jrf = (JbootRenderFactory)renderManager.getRenderFactory();
                render = jrf.getReturnValueRender(action, invocation.getReturnValue());
            }
            if (render == null) {
                render = renderManager.getRenderFactory().getDefaultRender(action.getViewPath() + action.getMethodName());
            }
            this.setResponse(response, action);
            render.setContext(request, response, action.getViewPath()).render();
        }
        catch (RenderException e) {
            if (log.isErrorEnabled()) {
                qs = request.getQueryString();
                log.error(qs == null ? target : target + "?" + qs, (Throwable)e);
            }
        }
        catch (ActionException e) {
            this.handleActionException(target, request, response, action, e);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                qs = request.getQueryString();
                String targetInfo = qs == null ? target : target + "?" + qs;
                String info = ClassUtil.buildMethodString(action.getMethod());
                log.error(info + " : " + targetInfo, (Throwable)e);
            }
            renderManager.getRenderFactory().getErrorRender(500).setContext(request, response, action.getViewPath()).render();
        }
        finally {
            JbootControllerContext.release();
            this.controllerFactory.recycle(controller);
        }
    }

    private void handleActionException(String target, HttpServletRequest request, HttpServletResponse response, Action action, ActionException e) {
        int errorCode = e.getErrorCode();
        String msg = null;
        if (errorCode == 404) {
            msg = "404 Not Found: ";
        } else if (errorCode == 400) {
            msg = "400 Bad Request: ";
        } else if (errorCode == 401) {
            msg = "401 Unauthorized: ";
        } else if (errorCode == 403) {
            msg = "403 Forbidden: ";
        }
        if (msg != null) {
            if (log.isWarnEnabled()) {
                String qs = request.getQueryString();
                msg = msg + (qs == null ? target : target + "?" + qs);
                if (e.getMessage() != null) {
                    msg = msg + "\n" + e.getMessage();
                }
                log.warn(msg);
            }
        } else if (log.isErrorEnabled()) {
            String qs = request.getQueryString();
            log.error(errorCode + " Error: " + (qs == null ? target : target + "?" + qs), (Throwable)e);
        }
        e.getErrorRender().setContext(request, response, action.getViewPath()).render();
    }

    private void invokeInvocation(Invocation inv) {
        new FixedInvocation(inv).invoke();
    }
}

