/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.render;

import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderManager;
import io.jboot.exception.JbootExceptionHolder;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class JbootErrorRender
extends Render {
    protected static final String contentType = "text/html; charset=" + JbootErrorRender.getEncoding();
    protected static final String poweredBy = "<center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center>";
    protected static final String html404 = "<html><head><title>404 Not Found</title></head><body bgcolor='white'><center><h1>404 Not Found</h1></center><hr><center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center></body></html>";
    protected static final String html401 = "<html><head><title>401 Unauthorized</title></head><body bgcolor='white'><center><h1>401 Unauthorized</h1></center><hr><center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center></body></html>";
    protected static final String html403 = "<html><head><title>403 Forbidden</title></head><body bgcolor='white'><center><h1>403 Forbidden</h1></center><hr><center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center></body></html>";
    protected static final String html500_header = "<html><head><title>500 Internal Server Error</title></head><body bgcolor='white'><center><h1>500 Internal Server Error</h1></center><hr>";
    protected static final String html500_footer = "<hr><center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center></body></html>";
    protected int errorCode;

    public JbootErrorRender(int errorCode, String view) {
        this.errorCode = errorCode;
        this.view = view;
    }

    public void render() {
        this.response.setStatus(this.getErrorCode());
        String view = this.getView();
        if (view != null) {
            RenderManager.me().getRenderFactory().getRender(view).setContext(this.request, this.response).render();
            return;
        }
        try {
            this.response.setContentType(contentType);
            PrintWriter writer = this.response.getWriter();
            writer.write(this.getErrorHtml());
        }
        catch (IOException e) {
            throw new RenderException((Throwable)e);
        }
    }

    public String getErrorHtml() {
        int errorCode = this.getErrorCode();
        if (errorCode == 404) {
            return html404;
        }
        if (errorCode == 401) {
            return html401;
        }
        if (errorCode == 403) {
            return html403;
        }
        if (errorCode == 500) {
            return this.build500ErrorInfo();
        }
        return "<html><head><title>" + errorCode + " Error</title></head><body bgcolor='white'><center><h1>" + errorCode + " Error</h1></center><hr>" + poweredBy + "</body></html>";
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String build500ErrorInfo() {
        StringBuilder stringBuilder = new StringBuilder(html500_header);
        List<String> messages = JbootExceptionHolder.getMessages();
        for (String message : messages) {
            stringBuilder.append(message).append("<br />");
        }
        List<Throwable> throwables = JbootExceptionHolder.getThrowables();
        for (Throwable throwable : throwables) {
            StackTraceElement[] elems;
            stringBuilder.append(throwable.getClass().getName() + " : " + throwable.getMessage()).append("<br />");
            for (StackTraceElement element : elems = throwable.getStackTrace()) {
                stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;at ").append(element).append("<br />");
            }
        }
        return stringBuilder.append(html500_footer).toString();
    }
}

